/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockNetwork
extends MockContainer {
    private MockInterface m_currentInterface;
    private MockNode m_currentNode;
    private Map<Integer, String> m_idToNameMap = new HashMap<Integer, String>();
    private int m_invalidPollCount;
    private Map<String, Integer> m_nameToIdMap = new HashMap<String, Integer>();
    private String m_criticalService = "ICMP";
    private String m_ifAlias;
    private int m_nextServiceId = 1;

    @Override
    public Event createDownEvent() {
        throw new UnsupportedOperationException("Cannot generate down event for the network");
    }

    @Override
    public Event createUpEvent() {
        throw new UnsupportedOperationException("Cannot generate up event for the network");
    }

    @Override
    public Event createNewEvent() {
        throw new UnsupportedOperationException("Cannot generate new event for the network");
    }

    @Override
    public Event createDeleteEvent() {
        throw new UnsupportedOperationException("Cannot generate delete event for the network");
    }

    public MockNetwork() {
        super(null);
    }

    public String getCriticalService() {
        return this.m_criticalService;
    }

    public void setCriticalService(String svcName) {
        this.m_criticalService = svcName;
    }

    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public void setIfAlias(String ifAlias) {
        this.m_currentInterface.setIfAlias(ifAlias);
    }

    public MockInterface addInterface(int nodeId, String ipAddr) {
        return this.getNode(nodeId).addInterface(ipAddr);
    }

    public MockInterface addInterface(String ipAddr) {
        this.m_currentInterface = this.m_currentNode.addInterface(ipAddr);
        return this.m_currentInterface;
    }

    public MockNode addNode(int nodeid, String label) {
        this.m_currentNode = (MockNode)this.addMember(new MockNode(this, nodeid, label));
        return this.m_currentNode;
    }

    public MockService addService(int nodeId, String ipAddr, String svcName) {
        int serviceId = this.getServiceId(svcName);
        return this.getInterface(nodeId, ipAddr).addService(svcName, serviceId);
    }

    public MockService addService(String svcName) {
        int serviceId = this.getServiceId(svcName);
        return this.m_currentInterface.addService(svcName, serviceId);
    }

    public Map<Integer, String> getIdToNameMap() {
        return Collections.unmodifiableMap(this.m_idToNameMap);
    }

    public MockInterface getInterface(int nodeid, String ipAddr) {
        MockNode node = this.getNode(nodeid);
        return node == null ? null : node.getInterface(ipAddr);
    }

    public int getInvalidPollCount() {
        return this.m_invalidPollCount;
    }

    @Override
    Object getKey() {
        return this;
    }

    public Map<String, Integer> getNameToIdMap() {
        return Collections.unmodifiableMap(this.m_nameToIdMap);
    }

    public MockNode getNode(int i) {
        return (MockNode)this.getMember(new Integer(i));
    }

    public int getNodeIdForInterface(final String ipAddr) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NodeFinder
        extends MockVisitorAdapter {
            MockNode node;

            NodeFinder() {
            }

            public MockNode getNode() {
                return this.node;
            }

            @Override
            public void visitInterface(MockInterface iface) {
                if (iface.getIpAddr().equals(ipAddr)) {
                    this.node = iface.getNode();
                }
            }
        }
        NodeFinder finder = new NodeFinder();
        this.visit(finder);
        return finder.getNode() == null ? -1 : finder.getNode().getNodeId();
    }

    public MockService getService(int nodeid, String ipAddr, String svcName) {
        MockInterface iface = this.getInterface(nodeid, ipAddr);
        return iface == null ? null : iface.getService(svcName);
    }

    private int getServiceId(String svcName) {
        int serviceId;
        if (this.m_nameToIdMap.containsKey(svcName)) {
            serviceId = this.m_nameToIdMap.get(svcName);
        } else {
            serviceId = this.m_nextServiceId++;
            Integer serviceIdObj = new Integer(serviceId);
            this.m_nameToIdMap.put(svcName, serviceIdObj);
            this.m_idToNameMap.put(serviceIdObj, svcName);
        }
        return serviceId;
    }

    public void receivedInvalidPoll(String ipAddr, String svcName) {
        ++this.m_invalidPollCount;
    }

    public synchronized void removeElement(MockElement element) {
        MockContainer parent = element.getParent();
        parent.removeMember(element);
    }

    public void removeInterface(MockInterface iface) {
        this.removeElement(iface);
    }

    public void removeNode(MockNode node) {
        this.removeElement(node);
    }

    public void removeService(MockService svc) {
        this.removeElement(svc);
    }

    public void resetInvalidPollCount() {
        this.m_invalidPollCount = 0;
    }

    @Override
    public void visit(MockVisitor v) {
        super.visit(v);
        v.visitNetwork(this);
        this.visitMembers(v);
    }

    public int getNodeCount() {
        class NodeCounter
        extends MockVisitorAdapter {
            int count = 0;

            NodeCounter() {
            }

            public void visitNode(MockNode node) {
                ++this.count;
            }

            public int getCount() {
                return this.count;
            }
        }
        NodeCounter counter = new NodeCounter();
        this.visit(counter);
        return counter.getCount();
    }

    public int getInterfaceCount() {
        class InterfaceCounter
        extends MockVisitorAdapter {
            int count = 0;

            InterfaceCounter() {
            }

            public void visitInterface(MockInterface iface) {
                ++this.count;
            }

            public int getCount() {
                return this.count;
            }
        }
        InterfaceCounter counter = new InterfaceCounter();
        this.visit(counter);
        return counter.getCount();
    }

    public int getServiceCount() {
        class ServiceCounter
        extends MockVisitorAdapter {
            int count = 0;

            ServiceCounter() {
            }

            public void visitService(MockService svc) {
                ++this.count;
            }

            public int getCount() {
                return this.count;
            }
        }
        ServiceCounter counter = new ServiceCounter();
        this.visit(counter);
        return counter.getCount();
    }

    public void createStandardNetwork() {
        this.setCriticalService("ICMP");
        this.addNode(1, "Router");
        this.addInterface("192.168.1.1");
        this.setIfAlias("dot1 interface alias");
        this.addService("ICMP");
        this.addService("SMTP");
        this.addInterface("192.168.1.2");
        this.setIfAlias("dot2 interface alias");
        this.addService("ICMP");
        this.addService("SMTP");
        this.addNode(2, "Server");
        this.addInterface("192.168.1.3");
        this.setIfAlias("dot3 interface alias");
        this.addService("ICMP");
        this.addService("HTTP");
        this.addNode(3, "Firewall");
        this.addInterface("192.168.1.4");
        this.addService("SMTP");
        this.addService("HTTP");
        this.addInterface("192.168.1.5");
        this.addService("SMTP");
        this.addService("HTTP");
    }
}

