/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.Date;
import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.PollAnticipator;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.xml.event.Event;

public abstract class MockElement {
    MockContainer m_parent;

    protected MockElement(MockContainer parent) {
        this.m_parent = parent;
    }

    public abstract void addAnticipator(PollAnticipator var1);

    public void bringDown() {
        this.setServicePollStatus(PollStatus.down());
    }

    public void bringUp() {
        this.setServicePollStatus(PollStatus.up());
    }

    public void bringUnresponsive() {
        this.setServicePollStatus(PollStatus.unresponsive());
    }

    abstract Object getKey();

    public MockContainer getParent() {
        return this.m_parent;
    }

    public MockNetwork getNetwork() {
        MockElement network = this;
        while (network.getParent() != null) {
            network = network.getParent();
        }
        return (MockNetwork)network;
    }

    public abstract int getPollCount();

    public abstract PollStatus getPollStatus();

    public void moveTo(MockContainer newParent) {
        this.m_parent.removeMember(this);
        newParent.addMember(this);
    }

    public abstract void removeAnticipator(PollAnticipator var1);

    public abstract void resetPollCount();

    void setParent(MockContainer parent) {
        this.m_parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServicePollStatus(final PollStatus newStatus) {
        MockVisitorAdapter statusSetter = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                svc.setPollStatus(newStatus);
            }
        };
        MockNetwork mockNetwork = this.getNetwork();
        synchronized (mockNetwork) {
            this.visit(statusSetter);
        }
    }

    public void visit(MockVisitor v) {
        v.visitElement(this);
    }

    public abstract Event createDownEvent();

    public abstract Event createUpEvent();

    public Event createUpEvent(Date date) {
        Event e = this.createUpEvent();
        MockEventUtil.setEventTime(e, date);
        return e;
    }

    public Event createDownEvent(Date date) {
        Event e = this.createDownEvent();
        MockEventUtil.setEventTime(e, date);
        return e;
    }

    public abstract Event createNewEvent();

    public abstract Event createDeleteEvent();
}

