/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.sql.Timestamp;
import org.opennms.netmgt.mock.MockService;

public class Outage {
    int m_nodeId;
    String m_ipAddr;
    int m_serviceId;
    String m_serviceName;
    int m_lostEventId;
    int m_regainedEventId;
    Timestamp m_lostEventTime;
    Timestamp m_regainedEventTime;

    public Outage(int nodeId, String ipAddr, int serviceId) {
        this.m_nodeId = nodeId;
        this.m_ipAddr = ipAddr;
        this.m_serviceId = serviceId;
    }

    public Outage(MockService svc) {
        this(svc.getNodeId(), svc.getIpAddr(), svc.getId());
    }

    public void setLostEvent(int eventId, Timestamp eventTime) {
        this.m_lostEventId = eventId;
        this.m_lostEventTime = eventTime;
    }

    public void setRegainedEvent(int eventId, Timestamp eventTime) {
        this.m_regainedEventId = eventId;
        this.m_regainedEventTime = eventTime;
    }

    public boolean isForService(MockService svc) {
        return this.m_nodeId == svc.getNodeId() && this.m_ipAddr.equals(svc.getIpAddr()) && this.m_serviceId == svc.getId();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "Outage[" + this.m_nodeId + "/" + this.m_ipAddr + "/" + (this.m_serviceName == null ? "" + this.m_serviceId : this.m_serviceName) + " cause: " + this.m_lostEventId + " resolution: " + this.m_regainedEventId + " ]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Outage)) {
            return false;
        }
        Outage outage = (Outage)o;
        return this.m_nodeId == outage.m_nodeId && this.m_ipAddr.equals(outage.m_ipAddr) && this.m_serviceId == outage.m_serviceId && this.m_lostEventId == outage.m_lostEventId && (this.m_lostEventTime == null ? outage.m_lostEventTime == null : this.m_lostEventTime.equals(outage.m_lostEventTime)) && this.m_regainedEventId == outage.m_regainedEventId && (this.m_regainedEventTime == null ? outage.m_regainedEventTime == null : this.m_regainedEventTime.equals(outage.m_regainedEventTime));
    }

    public String toDetailedString() {
        return "Outage[" + this.m_nodeId + ":" + this.m_ipAddr + ":" + this.m_serviceId + ":" + this.m_lostEventId + ":" + this.m_lostEventTime + ":" + this.m_regainedEventId + ":" + this.m_regainedEventTime + "]";
    }

    public int getServiceId() {
        return this.m_serviceId;
    }

    public void setServiceName(String svcName) {
        this.m_serviceName = svcName;
    }
}

