/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.util.spikehunter;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.jrobin.core.Archive;
import org.jrobin.core.FetchData;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.opennms.netmgt.util.spikehunter.DataAnalyzer;
import org.opennms.netmgt.util.spikehunter.DataReplacer;
import org.opennms.netmgt.util.spikehunter.NanDataReplacer;
import org.opennms.netmgt.util.spikehunter.NextDataReplacer;
import org.opennms.netmgt.util.spikehunter.PercentileDataAnalyzer;
import org.opennms.netmgt.util.spikehunter.PreviousDataReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpikeHunter {
    static RrdDb m_rrdFile;
    static String m_rrdFileName;
    static String m_dsNames;
    static int m_analysisStrategy;
    static List<Double> m_operands;
    static int m_replacementStrategy;
    static boolean m_dryRun;
    static boolean m_dumpContents;
    static boolean m_quiet;
    static boolean m_verbose;
    protected static Options m_options;
    protected static CommandLine m_commandLine;
    private static PrintStream m_out;

    public static void main(String[] args) {
        m_out = System.out;
        try {
            SpikeHunter.parseCmdLine(args);
        }
        catch (Exception e) {
            System.out.println("Error parsing command line arguments: " + e.getMessage());
        }
        try {
            m_rrdFile = SpikeHunter.openRrd();
        }
        catch (IOException ioe) {
            System.out.println("IO Exception trying to open RRD file: " + ioe.getMessage());
            System.exit(-1);
        }
        catch (RrdException rrde) {
            System.out.println("RRD Exception trying to open RRD file: " + rrde.getMessage());
            System.exit(-1);
        }
        if (m_dumpContents) {
            SpikeHunter.dumpContents();
            System.exit(0);
        }
        SpikeHunter.doReplacement();
        SpikeHunter.closeRrd();
    }

    public static void parseCmdLine(String[] argv) throws Exception {
        m_options.addOption("h", "help", false, "This help text");
        m_options.addOption("f", "file", true, "JRobin disk file on which to operate");
        m_options.addOption("d", "ds-name", true, "Data source names on which to operate, comma-separated. If unspecified, operate on all DSes.");
        m_options.addOption("a", "analysis-strategy", true, "Data analysis strategy. Defaults to percentile.");
        m_options.addOption("o", "operands", true, "Operands (numeric, comma-separated) for the selected analysis strategy. Defaults to 95,5.");
        m_options.addOption("r", "replacement-strategy", true, "Strategy for replacing spike samples, one of nan|previous|next, defaults to nan");
        m_options.addOption("n", "dry-run", false, "Just report spikes, do not make any changes to the JRobin disk file.");
        m_options.addOption("p", "dump-contents", false, "Just dump the DSes and RRAs in the JRobin disk file.");
        m_options.addOption("q", "quiet", false, "Do not print any informational output");
        m_options.addOption("v", "verbose", false, "Print plenty of informational output");
        PosixParser parser = new PosixParser();
        m_commandLine = parser.parse(m_options, argv);
        if (m_commandLine.hasOption("h")) {
            SpikeHunter.usage(m_options, m_commandLine);
            System.exit(0);
        }
        HashMap<String, Integer> analysisStrategies = new HashMap<String, Integer>();
        analysisStrategies.put("percentile", ANALYSIS_STRATEGIES.PERCENTILE_STRATEGY.ordinal());
        HashMap<String, Integer> replacementStrategies = new HashMap<String, Integer>();
        replacementStrategies.put("nan", REPLACEMENT_STRATEGIES.NAN_STRATEGY.ordinal());
        replacementStrategies.put("previous", REPLACEMENT_STRATEGIES.PREVIOUS_STRATEGY.ordinal());
        replacementStrategies.put("next", REPLACEMENT_STRATEGIES.NEXT_STRATEGY.ordinal());
        m_rrdFileName = m_commandLine.getOptionValue("f");
        m_dsNames = m_commandLine.getOptionValue("d", null);
        m_operands = new ArrayList<Double>();
        for (String operandStr : m_commandLine.getOptionValue("o", "95,5").split(",")) {
            m_operands.add(Double.parseDouble(operandStr));
        }
        m_analysisStrategy = (Integer)analysisStrategies.get(m_commandLine.getOptionValue("l", "percentile").toLowerCase());
        m_replacementStrategy = (Integer)replacementStrategies.get(m_commandLine.getOptionValue("r", "nan").toLowerCase());
        m_dryRun = m_commandLine.hasOption("n");
        m_dumpContents = m_commandLine.hasOption("p");
        m_quiet = m_commandLine.hasOption("q");
        m_verbose = m_commandLine.hasOption("v");
    }

    private static void usage(Options options, CommandLine cmd) {
        SpikeHunter.usage(options, cmd, null, null);
    }

    private static void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(m_out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("usage: spike-hunter [options]", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
        System.exit(0);
    }

    public static void printToUser(String msg) {
        if (m_quiet) {
            return;
        }
        m_out.println(msg);
    }

    private static RrdDb openRrd() throws IOException, RrdException {
        return new RrdDb(m_rrdFileName, m_dryRun);
    }

    private static void closeRrd() {
        try {
            m_rrdFile.close();
        }
        catch (IOException ioe) {
            System.out.println("IO Exception trying to close RRD file: " + ioe.getMessage());
        }
    }

    private static void dumpContents() {
        System.out.println("Number of archives: " + m_rrdFile.getArcCount());
        for (int i = 0; i < m_rrdFile.getArcCount(); ++i) {
            Archive arc = m_rrdFile.getArchive(i);
            String consolFun = "";
            double xff = Double.NaN;
            long arcStep = 0L;
            int steps = 0;
            int rows = 0;
            try {
                consolFun = arc.getConsolFun();
                xff = arc.getXff();
                arcStep = arc.getArcStep();
                steps = arc.getSteps();
                rows = arc.getRows();
            }
            catch (IOException e) {
                System.out.println("IO Exception trying to dump RRD file contents: " + e.getMessage());
            }
            System.out.println("\t" + consolFun + ":" + xff + ":" + steps + ":" + rows + " (Step size: " + arcStep + ")");
        }
        System.out.println();
        System.out.println("Number of data sources: " + m_rrdFile.getDsCount());
        try {
            for (String dsName : m_rrdFile.getDsNames()) {
                System.out.println("\t" + dsName);
            }
        }
        catch (IOException e) {
            System.out.println("IO Exception trying to enumerate data source names: " + e.getMessage());
        }
    }

    private static DataAnalyzer getDataAnalyzer() {
        PercentileDataAnalyzer analyzer = new PercentileDataAnalyzer(m_operands);
        return analyzer;
    }

    private static DataReplacer getDataReplacer() {
        DataReplacer replacer = m_replacementStrategy == REPLACEMENT_STRATEGIES.PREVIOUS_STRATEGY.ordinal() ? new PreviousDataReplacer() : (m_replacementStrategy == REPLACEMENT_STRATEGIES.NEXT_STRATEGY.ordinal() ? new NextDataReplacer() : new NanDataReplacer());
        return replacer;
    }

    private static void doReplacement() {
        if (m_dryRun) {
            SpikeHunter.printToUser("Running in dry-run mode, no modifications will be made to the specified file");
        }
        int arcCount = m_rrdFile.getArcCount();
        for (int arcIndex = 0; arcIndex < arcCount; ++arcIndex) {
            Archive thisArc = m_rrdFile.getArchive(arcIndex);
            SpikeHunter.replaceInArchive(thisArc);
        }
    }

    private static void replaceInArchive(Archive arc) {
        String consolFun = "";
        int arcSteps = 0;
        long startTime = 0L;
        long endTime = 0L;
        FetchData data = null;
        Object robin = null;
        try {
            consolFun = arc.getConsolFun();
            arcSteps = arc.getSteps();
            startTime = arc.getStartTime();
            endTime = arc.getEndTime();
        }
        catch (IOException e) {
            System.out.println("IO Exception trying to get archive information from RRD file: " + e.getMessage());
            System.exit(-1);
        }
        SpikeHunter.printToUser("Operating on archive with CF " + consolFun + ", " + arcSteps + " steps");
        try {
            data = m_rrdFile.createFetchRequest(consolFun, startTime, endTime).fetchData();
        }
        catch (RrdException rrde) {
            System.out.println("RRD Exception trying to create fetch request: " + rrde.getMessage());
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.out.println("IO Exception trying to create fetch request: " + ioe.getMessage());
            System.exit(-1);
        }
        String[] dsNames = m_dsNames == null ? data.getDsNames() : m_dsNames.split(",");
        for (String dsName : dsNames) {
            SpikeHunter.replaceInDs(arc, data, dsName);
        }
    }

    private static void replaceInDs(Archive arc, FetchData data, String dsName) {
        SpikeHunter.printToUser(" Operating on DS " + dsName);
        double[] origValues = null;
        try {
            origValues = data.getValues(dsName);
        }
        catch (RrdException e) {
            System.out.println("RRD Exception trying to get values from RRD file: " + e.getMessage());
            System.exit(-1);
        }
        DataAnalyzer analyzer = SpikeHunter.getDataAnalyzer();
        analyzer.setVerbose(m_verbose);
        List<Integer> violatorIndices = analyzer.findSamplesInViolation(origValues);
        if (m_verbose) {
            SpikeHunter.printToUser(" Number of values: " + origValues.length);
            SpikeHunter.printToUser(" Data analyzer: " + analyzer);
            SpikeHunter.printToUser(" Samples found in violation: " + violatorIndices.size());
        }
        DataReplacer replacer = SpikeHunter.getDataReplacer();
        double[] newValues = replacer.replaceValues(origValues, violatorIndices);
        SpikeHunter.printReplacementsToUser(data, dsName, newValues, violatorIndices);
        if (!m_dryRun) {
            SpikeHunter.replaceInFile(arc, data, dsName, newValues, violatorIndices);
        }
    }

    private static void printReplacementsToUser(FetchData data, String dsName, double[] newValues, List<Integer> violatorIndices) {
        long[] timestamps = data.getTimestamps();
        double[] origValues = null;
        try {
            origValues = data.getValues(dsName);
        }
        catch (RrdException e) {
            System.out.println("RRD Exception trying to get values from RRD file: " + e.getMessage());
        }
        for (int i : violatorIndices) {
            Date sampleDate = new Date(timestamps[i] * 1000L);
            SpikeHunter.printToUser("   Sample with timestamp " + sampleDate + " and value " + origValues[i] + " replaced by value " + newValues[i]);
        }
    }

    private static void replaceInFile(Archive arc, FetchData data, String dsName, double[] newValues, List<Integer> violatorIndices) {
        Robin robin = null;
        try {
            robin = arc.getRobin(m_rrdFile.getDsIndex(dsName));
        }
        catch (RrdException rrde) {
            System.out.println("RRD Exception trying to retrieve Robin from RRD file: " + rrde.getMessage());
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.out.println("RRD Exception trying to retrieve Robin from RRD file: " + ioe.getMessage());
            System.exit(-1);
        }
        for (int i : violatorIndices) {
            try {
                robin.setValue(i, newValues[i]);
            }
            catch (IOException e) {
                System.out.println("IO Exception trying to set value for index " + i + " to " + newValues[i]);
            }
        }
    }

    static {
        m_options = new Options();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum REPLACEMENT_STRATEGIES {
        NAN_STRATEGY,
        PREVIOUS_STRATEGY,
        NEXT_STRATEGY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ANALYSIS_STRATEGIES {
        PERCENTILE_STRATEGY;

    }
}

