/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.util.spikehunter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.util.spikehunter.DataAnalyzer;
import org.opennms.netmgt.util.spikehunter.SpikeHunter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PercentileDataAnalyzer
implements DataAnalyzer {
    private Double m_thresholdMultiplier;
    private int m_percentileNumber;
    private double m_percentileValue = Double.NaN;
    private boolean m_verbose = false;
    private double m_lowestValue = Double.NaN;
    private double m_highestValue = Double.NaN;

    public PercentileDataAnalyzer(List<Double> operands) {
        this.setParms(operands);
    }

    @Override
    public List<Integer> findSamplesInViolation(double[] values) {
        ArrayList<Integer> violatorIndices = new ArrayList<Integer>();
        this.calculatePercentile(values);
        double absThreshold = this.m_percentileValue * this.m_thresholdMultiplier;
        for (int i = 0; i < values.length; ++i) {
            if (Double.toString(values[i]).equals(Double.toString(Double.NaN)) || !(values[i] > absThreshold)) continue;
            violatorIndices.add(i);
        }
        return violatorIndices;
    }

    @Override
    public void setParms(List<Double> parms) {
        this.m_percentileNumber = parms.get(0).intValue();
        this.m_thresholdMultiplier = parms.get(1);
    }

    private void calculatePercentile(double[] values) {
        if (this.m_verbose) {
            SpikeHunter.printToUser("Before removing NaN values, " + values.length + " values are in the set");
        }
        ArrayList<Double> sortedValues = new ArrayList<Double>();
        for (double thisVal : values) {
            if (Double.toString(thisVal).equals(Double.toString(Double.NaN))) continue;
            sortedValues.add(thisVal);
        }
        if (this.m_verbose) {
            SpikeHunter.printToUser("After removing NaN values, " + sortedValues.size() + " values are left");
        }
        Collections.sort(sortedValues);
        float N = new Float(sortedValues.size()).floatValue();
        int rankInt = Math.round(new Float((double)(N / 100.0f * (float)this.m_percentileNumber) + 0.5).floatValue());
        if (this.m_verbose) {
            SpikeHunter.printToUser("Rank of Nth percentile value (N=" + this.m_percentileNumber + ") is " + rankInt);
        }
        this.m_percentileValue = (Double)sortedValues.get(rankInt);
        this.m_lowestValue = (Double)sortedValues.get(0);
        this.m_highestValue = (Double)sortedValues.get(sortedValues.size() - 1);
    }

    public String toString() {
        return "Nth-percentile analyzer (N=" + this.m_percentileNumber + ", P_N=" + (this.m_percentileValue != Double.NaN ? Double.valueOf(this.m_percentileValue) : "not yet calculated") + ", lowest=" + this.m_lowestValue + ", highest=" + this.m_highestValue + ")";
    }

    @Override
    public void setVerbose(boolean v) {
        this.m_verbose = v;
    }
}

