/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.expectations;

import java.util.concurrent.TimeUnit;
import org.opennms.smoketest.expectations.Expectation;
import org.openqa.selenium.WebDriver;

public class ExpectationBuilder {
    private final Expectation m_expectation;

    public ExpectationBuilder(String target) {
        this.m_expectation = new Expectation(target);
    }

    public ExpectationBuilder withText(String text) {
        this.m_expectation.addTextPresent(text);
        return this;
    }

    public ExpectationBuilder and() {
        this.m_expectation.setMatchType(Expectation.Type.AND);
        return this;
    }

    public ExpectationBuilder or() {
        this.m_expectation.setMatchType(Expectation.Type.OR);
        return this;
    }

    public ExpectationBuilder waitFor(long time, TimeUnit units) {
        this.m_expectation.setWaitTime(time, units);
        return this;
    }

    public static Expectation frontPage() {
        return new ExpectationBuilder("//a[contains(@href,'/opennms/index.jsp') ]").withText("Nodes with Pending Problems").build();
    }

    public Expectation build() {
        return this.m_expectation;
    }

    public void check(WebDriver webdriver) throws Exception {
        this.build().check(webdriver);
    }
}

