/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest;

import ch.qos.logback.classic.Level;
import com.google.common.base.Function;
import com.google.common.io.Files;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNMSSeleniumTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(OpenNMSSeleniumTestCase.class);
    public static final long LOAD_TIMEOUT = Long.getLong("org.opennms.smoketest.web-timeout", 120000L);
    public static final String OPENNMS_WEB_HOST = System.getProperty("org.opennms.smoketest.web-host", "localhost");
    public static final int OPENNMS_WEB_PORT = Integer.getInteger("org.opennms.smoketest.web-port", 8980);
    public static final String OPENNMS_EVENT_HOST = System.getProperty("org.opennms.smoketest.event-host", OPENNMS_WEB_HOST);
    public static final int OPENNMS_EVENT_PORT = Integer.getInteger("org.opennms.smoketest.event-port", 5817);
    public static final String BASE_URL = "http://" + OPENNMS_WEB_HOST + ":" + OPENNMS_WEB_PORT + "/";
    public static final String REQUISITION_NAME = "SeleniumTestGroup";
    public static final String USER_NAME = "SmokeTestUser";
    public static final String GROUP_NAME = "SmokeTestGroup";
    protected static final boolean usePhantomJS = Boolean.getBoolean("org.opennms.smoketest.webdriver.use-phantomjs") || Boolean.getBoolean("smoketest.usePhantomJS");
    protected WebDriver m_driver = null;
    protected WebDriverWait wait = null;
    @Rule
    public TestWatcher m_watcher = new TestWatcher(){

        protected void starting(Description description) {
            try {
                OpenNMSSeleniumTestCase.this.m_driver = OpenNMSSeleniumTestCase.this.getDriver();
                LOG.debug("Using driver: {}", (Object)OpenNMSSeleniumTestCase.this.m_driver);
                OpenNMSSeleniumTestCase.this.m_driver.manage().timeouts().implicitlyWait(LOAD_TIMEOUT, TimeUnit.MILLISECONDS);
                OpenNMSSeleniumTestCase.this.wait = new WebDriverWait(OpenNMSSeleniumTestCase.this.m_driver, TimeUnit.SECONDS.convert(LOAD_TIMEOUT, TimeUnit.MILLISECONDS));
                OpenNMSSeleniumTestCase.this.m_driver.get(BASE_URL + "opennms/login.jsp");
                OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.name((String)"j_username")));
                OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.name((String)"j_password")));
                OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.name((String)"Login")));
                OpenNMSSeleniumTestCase.this.enterText(By.name((String)"j_username"), "admin");
                OpenNMSSeleniumTestCase.this.enterText(By.name((String)"j_password"), "admin");
                OpenNMSSeleniumTestCase.this.findElementByName("Login").click();
                OpenNMSSeleniumTestCase.this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"//div[@id='content']")));
                try {
                    OpenNMSSeleniumTestCase.this.m_driver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
                    try {
                        OpenNMSSeleniumTestCase.this.findElementById("login-attempt-failed");
                        Assert.fail((String)("Login failed: " + OpenNMSSeleniumTestCase.this.findElementById("login-attempt-failed-reason").getText()));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                finally {
                    OpenNMSSeleniumTestCase.this.m_driver.manage().timeouts().implicitlyWait(LOAD_TIMEOUT, TimeUnit.MILLISECONDS);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | TimeoutException e) {
                LOG.debug("Failed to get driver", e);
                throw new RuntimeException("Tests aren't going to work.  Bailing.");
            }
        }

        protected void failed(Throwable e, Description description) {
            String testName = description.getMethodName();
            LOG.debug("Test {} failed... attempting to take screenshot.", (Object)testName);
            if (OpenNMSSeleniumTestCase.this.m_driver != null && OpenNMSSeleniumTestCase.this.m_driver instanceof TakesScreenshot) {
                TakesScreenshot shot = (TakesScreenshot)OpenNMSSeleniumTestCase.this.m_driver;
                try {
                    File from = (File)shot.getScreenshotAs(OutputType.FILE);
                    String screenshotFileName = "target" + File.separator + "screenshots" + File.separator + description.getClassName() + "." + testName + ".png";
                    File to = new File(screenshotFileName);
                    LOG.debug("Screenshot saved to: {}", (Object)from);
                    try {
                        to.getParentFile().mkdirs();
                        Files.move((File)from, (File)to);
                        LOG.debug("Screenshot moved to: {}", (Object)to);
                    }
                    catch (IOException ioe) {
                        LOG.debug("Failed to move screenshot from {} to {}", new Object[]{from, to, ioe});
                    }
                }
                catch (Exception sse) {
                    LOG.debug("Failed to take screenshot.", (Throwable)sse);
                }
            } else {
                LOG.debug("Driver can't take screenshots.");
            }
            LOG.debug("Current URL: {}", (Object)OpenNMSSeleniumTestCase.this.m_driver.getCurrentUrl());
            OpenNMSSeleniumTestCase.this.m_driver.navigate().back();
            LOG.debug("Previous URL: {}", (Object)OpenNMSSeleniumTestCase.this.m_driver.getCurrentUrl());
        }

        protected void finished(Description description) {
            try {
                OpenNMSSeleniumTestCase.this.deleteTestRequisition();
                OpenNMSSeleniumTestCase.this.deleteTestUser();
                OpenNMSSeleniumTestCase.this.deleteTestGroup();
            }
            catch (Exception e) {
                LOG.error("Cleaning up failed. Future tests will be in an unhandled state.", (Throwable)e);
            }
            LOG.debug("Shutting down Selenium.");
            if (OpenNMSSeleniumTestCase.this.m_driver != null) {
                try {
                    OpenNMSSeleniumTestCase.this.m_driver.get(BASE_URL + "opennms/j_spring_security_logout");
                }
                catch (SeleniumException e) {
                    // empty catch block
                }
                try {
                    OpenNMSSeleniumTestCase.this.m_driver.quit();
                }
                catch (Exception e) {
                    LOG.error("Failed while shutting down WebDriver for test {}.", (Object)description.getMethodName(), (Object)e);
                }
                OpenNMSSeleniumTestCase.this.m_driver = null;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    @BeforeClass
    public static void configureLogging() throws Exception {
        String logLevel = System.getProperty("org.opennms.smoketest.logLevel", "DEBUG");
        Logger logger = LoggerFactory.getLogger((String)"ROOT");
        if (logger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
            logbackLogger.setLevel(Level.valueOf((String)logLevel));
        }
    }

    protected WebDriver getDriver() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        WebDriver driver = null;
        String driverClass = System.getProperty("org.opennms.smoketest.webdriver.class", System.getProperty("webdriver.class"));
        if (driverClass != null) {
            driver = (WebDriver)Class.forName(driverClass).newInstance();
        }
        if (driver == null) {
            File phantomJS;
            if (usePhantomJS && (phantomJS = this.findPhantomJS()) != null) {
                DesiredCapabilities caps = new DesiredCapabilities();
                caps.setCapability("phantomjs.binary.path", phantomJS.toString());
                driver = new PhantomJSDriver((Capabilities)caps);
            }
            if (driver == null) {
                driver = new FirefoxDriver();
            }
        }
        return driver;
    }

    private File findPhantomJS() {
        String os = System.getProperty("os.name").toLowerCase();
        String extension = os.indexOf("win") >= 0 ? ".exe" : "";
        String path = System.getenv("PATH");
        if (path == null) {
            LOG.debug("findPhantomJS(): Unable to get PATH.");
            File phantomFile = new File("/usr/local/bin/phantomjs" + extension);
            LOG.debug("findPhantomJS(): trying {}", (Object)phantomFile);
            if (phantomFile.exists() && phantomFile.canExecute()) {
                return phantomFile;
            }
        } else {
            ArrayList<String> paths = new ArrayList<String>(Arrays.asList(path.split(File.pathSeparator)));
            paths.add("/usr/local/bin");
            paths.add("/usr/local/sbin");
            LOG.debug("findPhantomJS(): paths = {}", paths);
            for (String directory : paths) {
                File phantomFile = new File(directory + File.separator + "phantomjs" + extension);
                LOG.debug("findPhantomJS(): trying {}", (Object)phantomFile);
                if (!phantomFile.exists() || !phantomFile.canExecute()) continue;
                return phantomFile;
            }
        }
        return null;
    }

    protected WebDriverWait waitFor(long seconds) {
        return new WebDriverWait(this.m_driver, seconds);
    }

    protected ExpectedCondition<Boolean> pageContainsText(String text) {
        final String escapedText = text.replace("'", "\\'");
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String xpathExpression = "//*[contains(., '" + escapedText + "')]";
                LOG.debug("XPath expression: {}", (Object)xpathExpression);
                WebElement element = driver.findElement(By.xpath((String)xpathExpression));
                return element != null;
            }
        };
    }

    protected String handleAlert() {
        try {
            Alert alert = this.m_driver.switchTo().alert();
            String alertText = alert.getText();
            alert.dismiss();
            return alertText;
        }
        catch (NoAlertPresentException e) {
            LOG.debug("handleAlert: no alert is active");
            return null;
        }
    }

    protected void setChecked(By by) {
        WebElement element = this.m_driver.findElement(by);
        if (element.isSelected()) {
            return;
        }
        element.click();
    }

    protected void setUnchecked(By by) {
        WebElement element = this.m_driver.findElement(by);
        if (!element.isSelected()) {
            return;
        }
        element.click();
    }

    protected void clickMenuItem(String menuItemText, String submenuItemText, String submenuItemHref) {
        WebElement menuElement;
        Actions action = new Actions(this.m_driver);
        if (menuItemText.startsWith("name=")) {
            String menuItemName = menuItemText.replaceFirst("name=", "");
            menuElement = this.findElementByName(menuItemName);
        } else {
            menuElement = this.findElementByXpath("//a[contains(text(), '" + menuItemText + "')]");
        }
        action.moveToElement(menuElement, 2, 2).perform();
        WebElement submenuElement = submenuItemText != null ? (submenuItemHref == null ? this.findElementByXpath("//a[contains(text(), '" + submenuItemText + "')]") : this.findElementByXpath("//a[@href='" + submenuItemHref + "' and contains(text(), '" + submenuItemText + "')]")) : null;
        if (submenuElement == null) {
            this.wait.until((Function)ExpectedConditions.visibilityOf((WebElement)menuElement));
            menuElement.click();
        } else {
            this.wait.until((Function)ExpectedConditions.visibilityOf(submenuElement));
            submenuElement.click();
        }
    }

    protected void frontPage() {
        this.m_driver.get(BASE_URL + "opennms/");
        this.m_driver.findElement(By.id((String)"index-contentleft"));
    }

    public void adminPage() {
        this.m_driver.get(BASE_URL + "opennms/admin/index.jsp");
    }

    protected void nodePage() {
        this.m_driver.get(BASE_URL + "opennms/element/nodeList.htm");
    }

    protected void notificationsPage() {
        this.m_driver.get(BASE_URL + "opennms/notification/index.jsp");
    }

    protected void outagePage() {
        this.m_driver.get(BASE_URL + "opennms/outage/index.jsp");
    }

    protected void provisioningPage() {
        this.m_driver.get(BASE_URL + "opennms/admin/index.jsp");
        this.m_driver.findElement(By.linkText((String)"Manage Provisioning Requisitions")).click();
    }

    protected void reportsPage() {
        this.m_driver.get(BASE_URL + "opennms/report/index.jsp");
    }

    protected void searchPage() {
        this.m_driver.get(BASE_URL + "opennms/element/index.jsp");
    }

    protected void supportPage() {
        this.m_driver.get(BASE_URL + "opennms/support/index.htm");
    }

    protected void remotingPage() {
        this.m_driver.get(BASE_URL + "opennms-remoting/index.html");
    }

    protected void goBack() {
        LOG.warn("goBack() is supposedly not supported on Safari!");
        this.m_driver.navigate().back();
    }

    public WebElement findElementById(String id) {
        return this.m_driver.findElement(By.id((String)id));
    }

    public WebElement findElementByLink(String link) {
        return this.m_driver.findElement(By.linkText((String)link));
    }

    public WebElement findElementByName(String name) {
        return this.m_driver.findElement(By.name((String)name));
    }

    public WebElement findElementByXpath(String xpath) {
        return this.m_driver.findElement(By.xpath((String)xpath));
    }

    protected WebElement enterText(By selector, String text) {
        return OpenNMSSeleniumTestCase.enterText(this.m_driver, selector, text);
    }

    protected static WebElement enterText(WebDriver driver, By selector, String text) {
        LOG.debug("Enter text: '{}' into selector: {}", (Object)text, (Object)selector);
        WebElement element = driver.findElement(selector);
        element.clear();
        int i = 0;
        while (!"".equals(element.getAttribute("value").trim()) && i++ < 100) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        new Actions(driver).moveToElement(element).click().perform();
        element.sendKeys(new CharSequence[]{""});
        element.sendKeys(new CharSequence[]{text});
        i = 0;
        while (!text.equals(element.getAttribute("value")) && i++ < 100) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return element;
    }

    private Integer doRequest(HttpRequestBase request) throws ClientProtocolException, IOException, InterruptedException {
        final CountDownLatch waitForCompletion = new CountDownLatch(1);
        URI uri = request.getURI();
        HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        CloseableHttpClient client = HttpClients.createDefault();
        ResponseHandler<Integer> responseHandler = new ResponseHandler<Integer>(){

            public Integer handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                try {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300 || status == 400 || status == 404) {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        Integer n = status;
                        return n;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
                finally {
                    waitForCompletion.countDown();
                }
            }
        };
        Integer status = (Integer)client.execute(targetHost, (HttpRequest)request, (ResponseHandler)responseHandler, (HttpContext)context);
        waitForCompletion.await();
        client.close();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExistingRequisition(String foreignSource) {
        this.provisioningPage();
        LOG.debug("deleteExistingRequisition: Deleting Requisition: {}", (Object)foreignSource);
        if (this.getForeignSourceElement(foreignSource) == null) {
            LOG.debug("deleteExistingRequisition: Requisition {} is already gone.", (Object)foreignSource);
            return;
        }
        do {
            long nodesInRequisition = -1L;
            long nodesInDatabase = -1L;
            try {
                this.m_driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
                WebElement foreignSourceElement = this.getForeignSourceElement(foreignSource);
                nodesInRequisition = this.getNodesInRequisition(foreignSourceElement);
                nodesInDatabase = this.getNodesInDatabase(foreignSourceElement);
                LOG.debug("deleteExistingRequisition: nodesInRequisition={}, nodesInDatabase={}", (Object)nodesInRequisition, (Object)nodesInDatabase);
                if (nodesInDatabase > 0L) {
                    if (nodesInRequisition > 0L) {
                        LOG.debug("deleteExistingRequisition: We have requisitioned nodes, deleting them.");
                        try {
                            WebElement deleteNodesButton = foreignSourceElement.findElement(By.xpath((String)"//input[@type='button' and @value='Delete Nodes']"));
                            deleteNodesButton.click();
                            ((Alert)this.wait.until((Function)ExpectedConditions.alertIsPresent())).accept();
                        }
                        catch (NoSuchElementException deleteNodesButton) {}
                        continue;
                    }
                    LOG.debug("deleteExistingRequisition: We have no requisitioned nodes, but there are nodes in the database. Synchronizing.");
                    WebElement synchronizeButton = foreignSourceElement.findElement(By.xpath((String)"//input[@type='button' and @value='Synchronize']"));
                    synchronizeButton.click();
                    this.wait.until((Function)new WaitForNodesInDatabase(0));
                    continue;
                }
                try {
                    LOG.debug("deleteExistingRequisition: We have no nodes in the database, time to delete the requisition. PUSH THE BUTTON FRANK.");
                    WebElement deleteRequisitionButton = foreignSourceElement.findElement(By.xpath((String)"//input[@type='button' and @value='Delete Requisition']"));
                    deleteRequisitionButton.click();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            finally {
                this.m_driver.manage().timeouts().implicitlyWait(LOAD_TIMEOUT, TimeUnit.MILLISECONDS);
            }
        } while (this.getForeignSourceElement(foreignSource) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement getForeignSourceElement(String requisitionName) {
        String selector = "//span[@data-foreignSource='" + requisitionName + "']";
        WebElement foreignSourceElement = null;
        try {
            this.m_driver.manage().timeouts().implicitlyWait(2L, TimeUnit.SECONDS);
            foreignSourceElement = this.m_driver.findElement(By.xpath((String)selector));
        }
        catch (NoSuchElementException e) {
            LOG.debug("Could not find: {}", (Object)selector);
            WebElement webElement = null;
            return webElement;
        }
        finally {
            this.m_driver.manage().timeouts().implicitlyWait(LOAD_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        return foreignSourceElement;
    }

    protected void deleteTestRequisition() throws Exception {
        Integer responseCode = this.doRequest((HttpRequestBase)new HttpGet(BASE_URL + "/opennms/rest/requisitions/" + REQUISITION_NAME));
        LOG.debug("Checking for existing test requisition: {}", (Object)responseCode);
        if (responseCode == 404 || responseCode == 204) {
            LOG.debug("deleteTestRequisition: already deleted");
            return;
        }
        this.deleteExistingRequisition(REQUISITION_NAME);
        this.doRequest((HttpRequestBase)new HttpDelete(BASE_URL + "/opennms/rest/requisitions/" + REQUISITION_NAME));
        this.doRequest((HttpRequestBase)new HttpDelete(BASE_URL + "/opennms/rest/requisitions/deployed/" + REQUISITION_NAME));
        this.doRequest((HttpRequestBase)new HttpGet(BASE_URL + "/opennms/rest/requisitions"));
    }

    protected void deleteTestUser() throws Exception {
        this.doRequest((HttpRequestBase)new HttpDelete(BASE_URL + "/opennms/rest/users/" + USER_NAME));
    }

    protected void deleteTestGroup() throws Exception {
        this.doRequest((HttpRequestBase)new HttpDelete(BASE_URL + "/opennms/rest/groups/" + GROUP_NAME));
    }

    protected long getNodesInRequisition(WebElement element) {
        try {
            WebElement match = element.findElement(By.xpath((String)"//span[@data-requisitionedNodes]"));
            String nodes = match.getAttribute("data-requisitionedNodes");
            if (nodes != null) {
                Long nodeCount = Long.valueOf(nodes);
                LOG.debug("{} requisitioned nodes found.", (Object)nodeCount);
                return nodeCount;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LOG.debug("0 requisitioned nodes found.");
        return 0L;
    }

    protected long getNodesInDatabase(WebElement element) {
        try {
            WebElement match = element.findElement(By.xpath((String)"//span[@data-databaseNodes]"));
            String nodes = match.getAttribute("data-databaseNodes");
            if (nodes != null) {
                Long nodeCount = Long.valueOf(nodes);
                LOG.debug("{} database nodes found.", (Object)nodeCount);
                return nodeCount;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LOG.debug("0 database nodes found.");
        return 0L;
    }

    protected final class WaitForNodesInDatabase
    implements ExpectedCondition<Boolean> {
        private final int m_numberToMatch;

        public WaitForNodesInDatabase(int numberOfNodes) {
            this.m_numberToMatch = numberOfNodes;
        }

        public Boolean apply(WebDriver input) {
            OpenNMSSeleniumTestCase.this.provisioningPage();
            long nodes = OpenNMSSeleniumTestCase.this.getNodesInDatabase(OpenNMSSeleniumTestCase.this.getForeignSourceElement(OpenNMSSeleniumTestCase.REQUISITION_NAME));
            if (nodes == (long)this.m_numberToMatch) {
                return true;
            }
            return null;
        }
    }
}

