/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.rancid;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.Message;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.rancid.RancidNodeAuthentication;
import org.opennms.rancid.RetryThread;

public class RWS_MT_ClientApi
extends Thread {
    public static int ADD_NODE = 1;
    public static int UPDATE_NODE = 2;
    public static int DELETE_NODE = 3;
    public static int UP_NODE = 4;
    public static int DOWN_NODE = 5;
    public static int TOKEN = 100;
    private long retryDelay = 30000L;
    private int maxRetry = 3;
    private static boolean inited = false;
    private static ConcurrentLinkedQueue<Message> mainBuffer = new ConcurrentLinkedQueue();
    private static final Lock lock = new ReentrantLock();
    private static final Condition hasMessage = lock.newCondition();

    public void init() {
        if (inited) {
            return;
        }
        System.out.println("RWS_MT_ClientApi.init() called");
        RWSClientApi.init();
        inited = true;
        RetryThread.getInstance().init();
        RetryThread.getInstance().start();
    }

    public void setRetryDelaySeconds(int seconds) {
        this.retryDelay = seconds * 1000;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        System.out.println("RWS_MT_ClientApi.run() called");
        while (true) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    RWS_MT_ClientApi.lock.lock();
                    try {
                        while (RWS_MT_ClientApi.mainBuffer.isEmpty()) {
                            System.out.println("RWS_MT_ClientApi.run() await");
                            RWS_MT_ClientApi.hasMessage.await();
                        }
                        System.out.println("RWS_MT_ClientApi.run() rancidIt");
                        x = RWS_MT_ClientApi.mainBuffer.poll();
                        this.rancidIt(x);
                    }
                    finally {
                        RWS_MT_ClientApi.lock.unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                System.out.println(e.getMessage());
                continue;
            }
            catch (RancidApiException e) {
                System.out.println(e.getMessage());
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    protected static void reDoWork(Message m) {
        System.out.println("RWS_MT_ClientApi.reDoWork() called");
        lock.lock();
        try {
            mainBuffer.add(m);
            hasMessage.signal();
        }
        finally {
            lock.unlock();
        }
    }

    private void doWork(Message m) throws InterruptedException {
        System.out.println("RWS_MT_ClientApi.doWork() called");
        lock.lock();
        try {
            mainBuffer.add(m);
            hasMessage.signal();
        }
        finally {
            lock.unlock();
        }
    }

    private void rancidIt(Message m) throws RancidApiException {
        block14: {
            System.out.println("RWS_MT_ClientApi.rancidIt() called");
            try {
                if (m.getOperation() == ADD_NODE) {
                    System.out.println("RWS_MT_ClientApi.rancidIt() ADD_NODE " + m.getRancidNode().getDeviceName());
                    if (m.doRancid) {
                        RWSClientApi.createRWSRancidNode(m.getConnectionProperties(), m.getRancidNode());
                        m.doRancid = false;
                    }
                    if (m.doAuth) {
                        RWSClientApi.createOrUpdateRWSAuthNode(m.getConnectionProperties(), m.getRancidNodeAuthentication());
                        m.doAuth = false;
                    }
                } else if (m.getOperation() == UPDATE_NODE) {
                    System.out.println("RWS_MT_ClientApi.rancidIt() UPDATE_NODE" + m.getRancidNode().getDeviceName());
                    if (m.doRancid) {
                        RWSClientApi.updateRWSRancidNode(m.getConnectionProperties(), m.getRancidNode());
                        m.doRancid = false;
                    }
                    if (m.doAuth) {
                        RWSClientApi.createOrUpdateRWSAuthNode(m.getConnectionProperties(), m.getRancidNodeAuthentication());
                        m.doAuth = false;
                    }
                } else if (m.getOperation() == DELETE_NODE) {
                    System.out.println("RWS_MT_ClientApi.rancidIt() DELETE_NODE" + m.getRancidNode().getDeviceName());
                    if (m.doRancid) {
                        RWSClientApi.deleteRWSRancidNode(m.getConnectionProperties(), m.getRancidNode());
                        m.doRancid = false;
                    }
                    if (m.doAuth) {
                        RWSClientApi.deleteRWSAuthNode(m.getConnectionProperties(), m.getRancidNodeAuthentication());
                        m.doAuth = false;
                    }
                }
            }
            catch (RancidApiException e) {
                if (e.getRancidCode() != RancidApiException.RWS_BUSY) break block14;
                System.out.println("RWS_MT_ClientApi.rancidIt got exception");
                if (m.getRetry() >= this.maxRetry) {
                    throw new RancidApiException("Error: Server Busy", RancidApiException.RWS_BUSY);
                }
                m.incRetry();
                long i = System.currentTimeMillis() + this.retryDelay;
                System.out.println("RWS_MT_ClientApi.rancidIt inserting into retry buffer " + i);
                m.setTimestamp(i);
                RetryThread.putMessage(m);
            }
        }
    }

    public void addNode(RancidNode rn, ConnectionProperties cp) throws RancidApiException, InterruptedException {
        System.out.println("RWS_MT_ClientApi.addNode() called");
        Message m = new Message(rn, cp, ADD_NODE, 0, 0);
        this.doWork(m);
    }

    public void updNode(RancidNode rn, ConnectionProperties cp) throws RancidApiException, InterruptedException {
        Message m = new Message(rn, cp, UPDATE_NODE, 0, 0);
        System.out.println("RWS_MT_ClientApi.updNode() called");
        this.doWork(m);
    }

    public void delNode(RancidNode rn, ConnectionProperties cp) throws RancidApiException, InterruptedException {
        Message m = new Message(rn, cp, DELETE_NODE, 0, 0);
        System.out.println("RWS_MT_ClientApi.delNode() called");
        this.doWork(m);
    }

    public void addNode(RancidNode rn, RancidNodeAuthentication rna, ConnectionProperties cp) throws RancidApiException, InterruptedException {
        Message m = new Message(rn, rna, cp, ADD_NODE, 0, 0);
        System.out.println("RWS_MT_ClientApi.addNode() called");
        this.doWork(m);
    }

    public void updNode(RancidNode rn, RancidNodeAuthentication rna, ConnectionProperties cp) throws RancidApiException, InterruptedException {
        Message m = new Message(rn, rna, cp, UPDATE_NODE, 0, 0);
        System.out.println("RWS_MT_ClientApi.updNode() called");
        this.doWork(m);
    }

    public void delNode(RancidNode rn, RancidNodeAuthentication rna, ConnectionProperties cp) throws RancidApiException, InterruptedException {
        Message m = new Message(rn, rna, cp, DELETE_NODE, 0, 0);
        System.out.println("RWS_MT_ClientApi.delNode() called");
        this.doWork(m);
    }
}

