/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import simple.http.Pipeline;
import simple.http.Poller;

abstract class BufferPoller
extends Poller {
    protected byte[] buf = new byte[1024];
    protected int count;

    protected BufferPoller(Pipeline pipe) throws IOException {
        super(pipe);
    }

    public synchronized byte getByte(int pos) {
        if (pos > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[pos];
    }

    public synchronized void getBytes(int pos, byte[] b) {
        this.getBytes(pos, b, 0, b.length);
    }

    public synchronized void getBytes(int pos, byte[] b, int off, int len) {
        if (pos > this.count || pos + len > this.count) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, pos, b, off, len);
    }

    protected synchronized void ensureCapacity(int min) {
        if (this.buf.length < min) {
            int size = this.buf.length * 2;
            int max = Math.max(min, size);
            byte[] temp = new byte[max];
            System.arraycopy(this.buf, 0, temp, 0, this.count);
            this.buf = temp;
        }
    }

    public synchronized int length() {
        return this.count;
    }
}

