/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import simple.http.Header;

final class HeaderList {
    private Header[] list = new Header[16];
    private int count = 0;

    public int headerCount() {
        return this.count;
    }

    public void add(Header head) {
        if (this.count >= this.list.length) {
            this.expandCapacity();
        }
        this.list[this.count++] = head;
    }

    public Header remove(int off) {
        if (off >= this.count || off < 0) {
            throw new IndexOutOfBoundsException();
        }
        Header temp = this.list[off];
        this.list[off] = null;
        if (off == this.count - 1) {
            --this.count;
        } else {
            this.list[off] = this.list[--this.count];
        }
        return temp;
    }

    public void removeAll(String name) {
        int i = 0;
        while (i < this.count) {
            int index = this.indexOf(name, i);
            if (index >= 0) {
                this.remove(index);
                i = index - 1;
            }
            ++i;
        }
    }

    public String getValue(int off) {
        if (off < 0 || off >= this.count) {
            return null;
        }
        return this.list[off].getValue();
    }

    public String getName(int off) {
        if (off < 0 || off >= this.count) {
            return null;
        }
        return this.list[off].getName();
    }

    public String getValue(String name) {
        return this.getValue(this.indexOf(name));
    }

    public String[] getValues(String name) {
        int size = 0;
        int i = 0;
        while (i < this.count) {
            if (this.list[i].nameMatches(name)) {
                ++size;
            }
            ++i;
        }
        String[] value = new String[size];
        int i2 = 0;
        int n = 0;
        while (i2 < this.count) {
            if (this.list[i2].nameMatches(name)) {
                value[n++] = this.list[i2].getValue();
            }
            ++i2;
        }
        return value;
    }

    public Header get(int off) {
        if (off < 0 || off >= this.count) {
            return null;
        }
        return this.list[off];
    }

    public int indexOf(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.list[i].nameMatches(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String name, int from) {
        if (from >= this.count || from < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i = from;
        while (i < this.count) {
            if (this.list[i].nameMatches(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void expandCapacity() {
        int size = this.count * 2;
        Header[] temp = new Header[size];
        System.arraycopy(this.list, 0, temp, 0, this.count);
        this.list = temp;
    }
}

