/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRepresentation<T extends Serializable>
extends OutputRepresentation {
    private volatile T object;

    public ObjectRepresentation(Representation serializedRepresentation) throws IOException, ClassNotFoundException, IllegalArgumentException {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        if (!serializedRepresentation.getMediaType().equals(MediaType.APPLICATION_JAVA_OBJECT)) {
            throw new IllegalArgumentException("The serialized representation must have this media type: " + MediaType.APPLICATION_JAVA_OBJECT.toString());
        }
        ObjectInputStream ois = new ObjectInputStream(serializedRepresentation.getStream());
        this.object = (Serializable)ois.readObject();
        ois.close();
    }

    public ObjectRepresentation(T object) {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        this.object = object;
    }

    public T getObject() throws IOException {
        return this.object;
    }

    @Override
    public void release() {
        this.setObject(null);
        super.release();
    }

    public void setObject(T object) {
        this.object = object;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(this.getObject());
        oos.close();
    }
}

