/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.util.SslContextFactory;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsUtils
extends HttpUtils {
    private static final ConcurrentMap<String, Integer> keySizesCache = new ConcurrentHashMap<String, Integer>();

    public static Integer extractKeySize(String sslCipherSuite) {
        String encAlgorithm;
        int encAlgorithmIndex;
        Integer keySize = (Integer)keySizesCache.get(sslCipherSuite);
        if (keySize == null && (encAlgorithmIndex = sslCipherSuite.indexOf("WITH_")) >= 0 && (encAlgorithm = sslCipherSuite.substring(encAlgorithmIndex + 5)) != null) {
            if (encAlgorithm.startsWith("NULL_")) {
                keySize = 0;
            } else if (encAlgorithm.startsWith("IDEA_CBC_")) {
                keySize = 128;
            } else if (encAlgorithm.startsWith("RC2_CBC_40_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("RC4_40_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("RC4_128_")) {
                keySize = 128;
            } else if (encAlgorithm.startsWith("DES40_CBC_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("DES_CBC_")) {
                keySize = 56;
            } else if (encAlgorithm.startsWith("3DES_EDE_CBC_")) {
                keySize = 168;
            } else {
                StringTokenizer st = new StringTokenizer(encAlgorithm, "_");
                while (st.hasMoreTokens()) {
                    try {
                        keySize = Integer.valueOf(st.nextToken());
                        break;
                    }
                    catch (NumberFormatException e) {
                    }
                }
            }
            if (keySize != null) {
                keySizesCache.put(sslCipherSuite, keySize);
            }
        }
        return keySize;
    }

    public static String[] getDisabledCipherSuites(Helper<?> helper) {
        String[] disabledCipherSuitesParams;
        ArrayList<String> disabledCipherSuites = new ArrayList<String>();
        for (String disabledCipherSuitesParam : disabledCipherSuitesParams = helper.getHelpedParameters().getValuesArray("disabledCipherSuites")) {
            StringTokenizer st = new StringTokenizer(disabledCipherSuitesParam);
            while (st.hasMoreElements()) {
                disabledCipherSuites.add(st.nextToken());
            }
        }
        return disabledCipherSuites.size() > 0 ? disabledCipherSuites.toArray(new String[0]) : null;
    }

    public static String[] getEnabledCipherSuites(Helper<?> helper) {
        String[] enabledCipherSuitesParams;
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        for (String enabledCipherSuitesParam : enabledCipherSuitesParams = helper.getHelpedParameters().getValuesArray("enabledCipherSuites")) {
            StringTokenizer st = new StringTokenizer(enabledCipherSuitesParam);
            while (st.hasMoreElements()) {
                enabledCipherSuites.add(st.nextToken());
            }
        }
        return enabledCipherSuites.size() > 0 ? enabledCipherSuites.toArray(new String[0]) : null;
    }

    public static SslContextFactory getSslContextFactory(Helper<?> helper) {
        String[] sslContextFactoryNames;
        SslContextFactory result = (SslContextFactory)(helper.getContext() == null ? null : helper.getContext()).getAttributes().get("sslContextFactory");
        if (result == null && (sslContextFactoryNames = helper.getHelpedParameters().getValuesArray("sslContextFactory")) != null) {
            for (String sslContextFactoryName : sslContextFactoryNames) {
                try {
                    Class<SslContextFactory> sslContextFactoryClass = Class.forName(sslContextFactoryName).asSubclass(SslContextFactory.class);
                    result = sslContextFactoryClass.newInstance();
                    result.init(helper.getHelpedParameters());
                }
                catch (ClassNotFoundException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to find SslContextFactory class: " + sslContextFactoryName, e);
                }
                catch (ClassCastException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Class " + sslContextFactoryName + " does not implement SslContextFactory.", e);
                }
                catch (InstantiationException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Could not instantiate class " + sslContextFactoryName + " with default constructor.", e);
                }
                catch (IllegalAccessException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Illegal access when instantiating class " + sslContextFactoryName + ".", e);
                }
            }
        }
        return result;
    }
}

