/*
 * Decompiled with CFR 0.152.
 */
package simple.util.parse;

import simple.util.parse.ParseBuffer;

public class PropertyBuffer
extends ParseBuffer {
    private ParseBuffer name = new ParseBuffer();
    private ParseBuffer text = new ParseBuffer();
    private int off;

    public String getValue() {
        if (this.text.length() <= 0) {
            this.parse();
        }
        return this.text.toString();
    }

    private void parse() {
        while (this.off < this.count) {
            char next;
            if ((next = this.buf[this.off++]) == '$' && this.off < this.count) {
                if (this.buf[this.off++] == '{') {
                    this.name();
                    continue;
                }
                --this.off;
            }
            this.text.append(next);
        }
    }

    private void name() {
        while (this.off < this.count) {
            char next;
            if ((next = this.buf[this.off++]) == '}') {
                this.replace();
                break;
            }
            this.name.append(next);
        }
        if (this.name.length() > 0) {
            this.text.append("${" + this.name);
        }
    }

    private void replace() {
        if (this.name.length() > 0) {
            this.replace(this.name);
        }
        this.name.clear();
    }

    private void replace(ParseBuffer name) {
        this.replace(name.toString());
    }

    private void replace(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            this.text.append("${" + name + "}");
        } else {
            this.text.append(value);
        }
    }

    public void clear() {
        this.name.clear();
        this.text.clear();
        super.clear();
        this.off = 0;
    }

    public String toString() {
        return this.getValue();
    }
}

