/*
 * Decompiled with CFR 0.152.
 */
package simple.util;

import java.io.Serializable;

public class PriorityQueue
implements Serializable {
    protected long maxPriority = Long.MAX_VALUE;
    protected Object[] data;
    protected long[] value;
    protected int count;
    protected int capacity;

    public PriorityQueue() {
        this.init(20);
    }

    public PriorityQueue(int capacity) {
        this.init(capacity);
    }

    public PriorityQueue(int capacity, long maxPriority) {
        this.maxPriority = maxPriority;
        this.init(capacity);
    }

    private void init(int size) {
        this.capacity = size;
        this.data = new Object[this.capacity + 1];
        this.value = new long[this.capacity + 1];
        this.value[0] = this.maxPriority;
        this.data[0] = null;
    }

    public void add(Object element, long priority) {
        if (this.count++ >= this.capacity) {
            this.expandCapacity();
        }
        this.value[this.count] = priority;
        this.data[this.count] = element;
        this.bubbleUp(this.count);
    }

    public Object remove() {
        if (this.count == 0) {
            return null;
        }
        Object element = this.data[1];
        this.data[1] = this.data[this.count];
        this.value[1] = this.value[this.count];
        this.data[this.count] = null;
        this.value[this.count--] = 0L;
        this.bubbleDown(1);
        return element;
    }

    protected void bubbleDown(int pos) {
        Object element = this.data[pos];
        long priority = this.value[pos];
        while (pos * 2 <= this.count) {
            int child = pos * 2;
            if (child != this.count && this.value[child] < this.value[child + 1]) {
                ++child;
            }
            if (priority >= this.value[child]) break;
            this.value[pos] = this.value[child];
            this.data[pos] = this.data[child];
            pos = child;
        }
        this.value[pos] = priority;
        this.data[pos] = element;
    }

    protected void bubbleUp(int pos) {
        Object element = this.data[pos];
        long priority = this.value[pos];
        while (this.value[pos / 2] < priority) {
            this.value[pos] = this.value[pos / 2];
            this.data[pos] = this.data[pos / 2];
            pos /= 2;
        }
        this.value[pos] = priority;
        this.data[pos] = element;
    }

    protected void expandCapacity() {
        this.capacity = this.count * 2;
        Object[] elements = new Object[this.capacity + 1];
        long[] prioritys = new long[this.capacity + 1];
        System.arraycopy(this.data, 0, elements, 0, this.data.length);
        System.arraycopy(this.value, 0, prioritys, 0, this.data.length);
        this.data = elements;
        this.value = prioritys;
    }

    public void clear() {
        int i = 1;
        while (i < this.count) {
            this.data[i] = null;
            ++i;
        }
        this.count = 0;
    }

    public int length() {
        return this.count;
    }
}

