/*
 * Decompiled with CFR 0.152.
 */
package simple.util;

import java.lang.reflect.Method;

public class Introspector {
    private Method[] list;

    public Introspector(Class type) {
        this.list = type.getMethods();
    }

    public Method match(String name, Class type) throws Exception {
        return this.match(name, new Class[]{type});
    }

    public Method match(String name, Class[] types) {
        int i = 0;
        while (i < this.list.length) {
            if (this.list[i].getName().equals(name) && this.isMatch(this.list[i], types)) {
                return this.list[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isMatch(Method method, Class[] types) {
        Class<?>[] list = method.getParameterTypes();
        if (list.length == types.length) {
            int i = 0;
            while (i < list.length) {
                if (types[i] != null && !list[i].isAssignableFrom(types[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Object invoke(String name, Object target, Object data) throws Exception {
        return this.invoke(name, target, new Object[]{data});
    }

    public Object invoke(String name, Object target, Object[] list) throws Exception {
        Class[] types = new Class[list.length];
        int i = 0;
        while (i < list.length) {
            if (list[i] != null) {
                types[i] = list[i].getClass();
            }
            ++i;
        }
        Method method = this.match(name, types);
        if (method == null) {
            throw new NoSuchMethodException("No match found");
        }
        return method.invoke(target, list);
    }
}

