/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.File;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import simple.http.serve.ContentResolver;
import simple.http.serve.FileIndex;
import simple.http.serve.Index;
import simple.http.serve.Indexer;
import simple.http.serve.Locator;
import simple.util.cache.Cache;
import simple.util.net.Path;
import simple.util.net.URI;

final class FileIndexer
implements Indexer {
    private static ResourceBundle content;
    private ContentResolver resolver;
    private Cache cache;
    private File base;

    static {
        try {
            content = ResourceBundle.getBundle("simple.http.serve.Content");
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
    }

    public FileIndexer(Locator lookup, File base) {
        this.resolver = new ContentResolver(lookup);
        this.cache = new Cache(20, 100);
        this.base = base;
    }

    public Index getIndex(String target) {
        Object data = this.cache.lookup(target);
        Index index = (Index)data;
        if (index == null) {
            index = this.getIndex(this, target);
        }
        return index;
    }

    public Index getIndex(Indexer indexer, String target) {
        FileIndex index = new FileIndex(indexer, target);
        if (target.indexOf(63) < 0) {
            this.cache.cache(target, index);
        }
        return index;
    }

    public File getFile(URI target) {
        return this.getFile(target.getPath());
    }

    public Path getPath(URI target) {
        return target.getPath();
    }

    private File getFile(Path path) {
        return new File(this.base, path.toString().replace('/', File.separatorChar));
    }

    public Locale getLocale(URI target) {
        return this.getLocale(target.getPath());
    }

    private Locale getLocale(Path path) {
        String place = path.getCountry();
        String talk = path.getLanguage();
        if (talk == null) {
            return Locale.getDefault();
        }
        if (place == null) {
            return new Locale(talk);
        }
        return new Locale(talk, place);
    }

    public String getContentType(URI target) {
        return this.getContentType(target.getPath());
    }

    private String getContentType(Path path) {
        String ext = path.getExtension();
        String target = path.getPath();
        return this.getContentType(target, ext);
    }

    private String getContentType(String path, String ext) {
        try {
            String type = this.resolver.getContentType(path);
            if (type != null) {
                return type;
            }
            if (ext != null) {
                return content.getString(ext);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return "application/octetstream";
    }
}

