/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import java.lang.reflect.Constructor;
import simple.http.load.Mapper;
import simple.http.load.PatternMapper;
import simple.http.serve.Context;

public final class MapperFactory {
    public static Mapper getInstance(Context context) {
        String property = "simple.http.load.mapper";
        String className = System.getProperty(property);
        if (className == null) {
            return new PatternMapper(context);
        }
        try {
            return MapperFactory.getInstance(context, className);
        }
        catch (Exception e) {
            return new PatternMapper(context);
        }
    }

    private static Mapper getInstance(Context context, String className) throws Exception {
        Constructor method = MapperFactory.getConstructor(className);
        return (Mapper)method.newInstance(context);
    }

    private static Constructor getConstructor(String className) throws Exception {
        return MapperFactory.getConstructor(Class.forName(className, false, MapperFactory.class.getClassLoader()));
    }

    private static Constructor getConstructor(Class type) throws Exception {
        Class[] types = new Class[]{Context.class};
        return type.getDeclaredConstructor(types);
    }
}

