/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.util.Hashtable;
import simple.http.State;
import simple.http.StateCookie;
import simple.util.net.Cookie;
import simple.util.parse.CookieParser;

class PlainState
implements State {
    private Hashtable state = new Hashtable();
    private Hashtable set = new Hashtable();

    public PlainState() {
        this(new String[0]);
    }

    public PlainState(String[] list) {
        this.init(list);
    }

    private void init(String[] list) {
        CookieParser it = new CookieParser();
        int i = 0;
        while (i < list.length) {
            it.parse(list[i]);
            while (it.hasMore()) {
                Cookie next = it.next();
                this.state.put(next.getName(), next);
            }
            ++i;
        }
    }

    public synchronized void setCookie(Cookie cookie) {
        this.state.put(cookie.getName(), cookie);
        this.set.put(cookie.getName(), cookie);
    }

    public synchronized void setCookie(String name, String value) {
        this.setCookie(new Cookie(name, value, "/"));
    }

    public synchronized void setCookie(String name, String value, String path) {
        this.setCookie(new Cookie(name, value, path));
    }

    public synchronized Cookie getCookie(String name) {
        Cookie cookie = (Cookie)this.state.get(name);
        if (cookie != null) {
            return new StateCookie(this, cookie);
        }
        return null;
    }

    public synchronized String getValue(String name) {
        Cookie cookie = (Cookie)this.state.get(name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public synchronized Cookie[] getSetCookies() {
        Cookie[] list = new Cookie[this.set.size()];
        Object[] keys = this.set.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            list[i] = this.getCookie(keys[i].toString());
            ++i;
        }
        return list;
    }

    public synchronized Cookie[] getCookies() {
        Cookie[] list = new Cookie[this.state.size()];
        Object[] keys = this.state.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            list[i] = this.getCookie(keys[i].toString());
            ++i;
        }
        return list;
    }

    public synchronized Cookie remove(String name) {
        return (Cookie)this.state.remove(name);
    }

    public synchronized boolean contains(String name) {
        return this.state.containsKey(name);
    }

    public synchronized boolean isEmpty() {
        return this.state.isEmpty();
    }

    public synchronized int size() {
        return this.state.size();
    }

    public synchronized void clear() {
        this.state.clear();
    }
}

