/*
 * Decompiled with CFR 0.152.
 */
package simple.util.parse;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import simple.util.net.Parameters;
import simple.util.net.Path;
import simple.util.net.URI;
import simple.util.parse.ParameterParser;
import simple.util.parse.Parser;
import simple.util.parse.PathParser;

public class URIParser
extends Parser
implements URI {
    private Hashtable param = new Hashtable();
    private Token path = new Token();
    private Token domain = new Token();
    private Token query = new Token();
    private Token name;
    private Token value;
    private Token scheme = new Token();
    private int port;

    public URIParser() {
        this.name = new Token();
        this.value = new Token();
    }

    public URIParser(String text) {
        this();
        this.parse(text);
    }

    public String getScheme() {
        return this.scheme.toString();
    }

    public String getDomain() {
        return this.domain.toString();
    }

    public Path getPath() {
        String text = this.path.toString();
        if (text != null) {
            return new PathParser(text);
        }
        return new PathParser("/");
    }

    public Parameters getQuery() {
        String text = this.query.toString();
        if (text != null) {
            return new ParameterParser(text);
        }
        return new ParameterParser("");
    }

    public int getPort() {
        return this.port <= 0 ? -1 : this.port;
    }

    public Enumeration getParameterNames() {
        return this.param.keys();
    }

    public String getParameter(String name) {
        return (String)this.param.get(name);
    }

    public void setScheme(String value) {
        this.scheme.value = value;
    }

    public void setDomain(String value) {
        this.domain.value = value;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPath(String text) {
        if (!text.startsWith("/")) {
            text = "/" + text;
        }
        this.param.clear();
        this.path.clear();
        this.parsePath(text);
    }

    public void setPath(Path path) {
        if (path != null) {
            this.setPath(path.getPath());
        } else {
            this.setPath("/");
        }
    }

    private void parsePath(String path) {
        this.count = path.length();
        this.ensureCapacity(this.count);
        path.getChars(0, this.count, this.buf, 0);
        this.off = 0;
        this.path();
    }

    public void setQuery(String value) {
        this.query.value = value;
    }

    public void setQuery(Parameters query) {
        if (this.value != null) {
            this.setQuery(query.toString());
        } else {
            this.setQuery("");
        }
    }

    protected void parse() {
        if (this.count > 0) {
            if (this.buf[0] == '/') {
                this.relativeURI();
            } else {
                this.absoluteURI();
            }
        }
    }

    protected void init() {
        this.param.clear();
        this.domain.clear();
        this.path.clear();
        this.query.clear();
        this.scheme.clear();
        this.port = 0;
        this.off = 0;
    }

    private void absoluteURI() {
        this.scheme();
        this.netPath();
    }

    private void scheme() {
        int mark = this.off;
        int pos = this.off;
        if (this.alpha(this.buf[this.off])) {
            while (this.off < this.count) {
                char next;
                if (this.schemeChar(next = this.buf[this.off++])) {
                    ++pos;
                    continue;
                }
                if (next == ':') {
                    if (this.skip("//")) break;
                    this.off = mark;
                    pos = mark;
                    break;
                }
                this.off = mark;
                pos = mark;
                break;
            }
            this.scheme.len = pos - mark;
            this.scheme.off = mark;
        }
    }

    private boolean schemeChar(char c) {
        switch (c) {
            case '+': 
            case '-': 
            case '.': {
                return true;
            }
        }
        return this.alphanum(c);
    }

    private void netPath() {
        this.domain();
        if (this.skip(":")) {
            this.port();
        }
        this.relativeURI();
    }

    private void relativeURI() {
        this.path();
        if (this.skip("?")) {
            this.query();
        }
    }

    private void port() {
        while (this.off < this.count) {
            if (!this.digit(this.buf[this.off])) break;
            this.port *= 10;
            this.port += this.buf[this.off];
            this.port -= 48;
            ++this.off;
        }
    }

    private void domain() {
        int mark = this.off;
        block3: while (this.off < this.count) {
            switch (this.buf[this.off]) {
                case '/': 
                case ':': 
                case '?': {
                    break block3;
                }
                default: {
                    ++this.off;
                }
            }
        }
        this.domain.len = this.off - mark;
        this.domain.off = mark;
    }

    private void path() {
        int mark = this.off;
        int pos = this.off;
        block0: while (this.skip("/")) {
            this.buf[pos++] = 47;
            while (this.off < this.count) {
                if (this.buf[this.off] == ';') {
                    while (this.skip(";")) {
                        this.param();
                        this.insert();
                    }
                    continue block0;
                }
                if (this.buf[this.off] == '%') {
                    this.escape();
                } else if (!this.pchar(this.buf[this.off])) continue block0;
                this.buf[pos++] = this.buf[this.off++];
            }
        }
        this.path.len = pos - mark;
        this.path.off = mark;
    }

    private void query() {
        this.query.len = this.count - this.off;
        this.query.off = this.off;
    }

    private void param() {
        this.name();
        if (this.skip("=")) {
            this.value();
        }
    }

    private void name() {
        int mark = this.off;
        int pos = this.off;
        while (this.off < this.count) {
            if (this.buf[this.off] == '%') {
                this.escape();
            } else if (this.buf[this.off] == '=' || !this.pchar(this.buf[this.off])) break;
            this.buf[pos++] = this.buf[this.off++];
        }
        this.name.len = pos - mark;
        this.name.off = mark;
    }

    private void value() {
        int mark = this.off;
        int pos = this.off;
        while (this.off < this.count) {
            if (this.buf[this.off] == '%') {
                this.escape();
            } else if (!this.pchar(this.buf[this.off])) break;
            this.buf[pos++] = this.buf[this.off++];
        }
        this.value.len = pos - mark;
        this.value.off = mark;
    }

    private void insert() {
        if (this.value.length() > 0 && this.name.length() > 0) {
            this.insert(this.name, this.value);
        }
        this.name.clear();
        this.value.clear();
    }

    private void insert(Token name, Token value) {
        this.insert(name.toString(), value.toString());
    }

    private void insert(String name, String value) {
        this.param.put(name, value);
    }

    private void escape() {
        int peek = this.peek(this.off);
        if (!this.unicode(peek)) {
            this.binary(peek);
        }
    }

    private boolean binary(int peek) {
        if (this.off + 2 < this.count) {
            this.off += 2;
            this.buf[this.off] = this.bits(peek);
        }
        return true;
    }

    private boolean unicode(int peek) {
        if ((peek & 0x80) == 0) {
            return this.unicode(peek, 0);
        }
        if ((peek & 0xE0) == 192) {
            return this.unicode(peek & 0x1F, 1);
        }
        if ((peek & 0xF0) == 224) {
            return this.unicode(peek & 0xF, 2);
        }
        if ((peek & 0xF8) == 240) {
            return this.unicode(peek & 7, 3);
        }
        if ((peek & 0xFC) == 248) {
            return this.unicode(peek & 3, 4);
        }
        if ((peek & 0xFE) == 252) {
            return this.unicode(peek & 1, 5);
        }
        return false;
    }

    private boolean unicode(int peek, int more) {
        if (this.off + more * 3 >= this.count) {
            return false;
        }
        return this.unicode(peek, more, this.off);
    }

    private boolean unicode(int peek, int more, int pos) {
        while (more-- > 0) {
            int next;
            int hex;
            if (this.buf[pos] == '%' && ((hex = this.peek(next = pos + 3)) & 0xC0) == 128) {
                peek = peek << 6 | hex & 0x3F;
                pos = next;
                continue;
            }
            return false;
        }
        if (pos + 2 < this.count) {
            this.off = pos + 2;
            this.buf[this.off] = this.bits(peek);
        }
        return true;
    }

    private char bits(int data) {
        return (char)data;
    }

    private int peek(int pos) {
        if (this.buf[pos] == '%') {
            if (this.count <= pos + 2) {
                return -1;
            }
            char high = this.buf[pos + 1];
            char low = this.buf[pos + 2];
            return this.convert(high, low);
        }
        return -1;
    }

    private int convert(char high, char low) {
        int hex = 0;
        if (this.hex(high) && this.hex(low)) {
            if ('A' <= high && high <= 'F') {
                high = (char)(high - -32);
            }
            hex = high >= 'a' ? (hex ^= high - 97 + 10) : (hex ^= high - 48);
            hex <<= 4;
            if ('A' <= low && low <= 'F') {
                low = (char)(low - -32);
            }
            hex = low >= 'a' ? (hex ^= low - 97 + 10) : (hex ^= low - 48);
            return hex;
        }
        return -1;
    }

    private boolean hex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (ch >= 'a' && ch <= 'f') {
            return true;
        }
        return ch >= 'A' && ch <= 'F';
    }

    private boolean unreserved(char c) {
        return this.mark(c) || this.alphanum(c);
    }

    private boolean alphanum(char c) {
        return this.digit(c) || this.alpha(c);
    }

    private boolean alpha(char c) {
        return c <= 'z' && 'a' <= c || c <= 'Z' && 'A' <= c;
    }

    private boolean mark(char c) {
        switch (c) {
            case '!': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '-': 
            case '.': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private boolean pchar(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case ':': 
            case '=': 
            case '@': {
                return true;
            }
        }
        return this.unreserved(c);
    }

    private boolean reserved(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '+': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.scheme.length() > 0 ? this.scheme + "://" : "") + (this.domain.length() > 0 ? this.domain + (this.port > 0 ? ":" + this.port : "") : "") + this.getPath() + (this.query.length() > 0 ? "?" + this.query : "");
    }

    private class Token
    implements Serializable {
        public String value;
        public int off;
        public int len;

        private Token() {
        }

        public void clear() {
            this.value = null;
            this.len = 0;
        }

        public int length() {
            if (this.value == null) {
                return this.len;
            }
            return this.value.length();
        }

        public String toString() {
            if (this.value != null) {
                return this.value;
            }
            if (this.len > 0) {
                this.value = new String(URIParser.this.buf, this.off, this.len);
            }
            return this.value;
        }
    }
}

