/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import simple.util.ByteStore;

final class RequestParser {
    private Token uri = new Token();
    private Token method = new Token();
    private int major;
    private int minor;
    private byte[] buf;
    private int count;
    private int off;
    private int len;

    public RequestParser(ByteStore buf) {
        this.buf = new byte[buf.length()];
        buf.getBytes(0, this.buf, 0, this.buf.length);
        this.len = this.buf.length;
        this.off = 0;
        this.count = 0;
        this.parse();
    }

    public String getMethod() {
        try {
            return this.createMethod();
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getURI() {
        try {
            return this.createURI();
        }
        catch (IOException e) {
            return "";
        }
    }

    private String createMethod() throws UnsupportedEncodingException {
        return new String(this.buf, this.method.off, this.method.len, "iso-8859-1");
    }

    private String createURI() throws UnsupportedEncodingException {
        return new String(this.buf, this.uri.off, this.uri.len, "iso-8859-1");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    private void uri() {
        this.whitespace();
        this.uri.off = this.off;
        this.uri.len = 0;
        while (this.count < this.len) {
            if (this.space(this.buf[this.off])) break;
            ++this.uri.len;
            ++this.count;
            ++this.off;
        }
    }

    private void method() {
        this.whitespace();
        this.method.off = this.off;
        this.method.len = 0;
        while (this.count < this.len) {
            if (this.space(this.buf[this.off])) break;
            ++this.method.len;
            ++this.count;
            ++this.off;
        }
    }

    private void version() {
        this.whitespace();
        this.off += 5;
        this.count += 5;
        this.major();
        ++this.off;
        ++this.count;
        this.minor();
    }

    private void major() {
        while (this.count < this.len) {
            if (!this.digit(this.buf[this.off])) break;
            this.major *= 10;
            this.major += this.buf[this.off++];
            this.major -= 48;
            ++this.count;
        }
    }

    private void minor() {
        while (this.count < this.len) {
            if (!this.digit(this.buf[this.off])) break;
            this.minor *= 10;
            this.minor += this.buf[this.off++];
            this.minor -= 48;
            ++this.count;
        }
    }

    private void whitespace() {
        while (this.count < this.len) {
            if (!this.space(this.buf[this.off])) break;
            ++this.count;
            ++this.off;
        }
    }

    private boolean space(byte b) {
        return b == 32 || b == 9;
    }

    private boolean digit(byte b) {
        return b >= 48 && b <= 57;
    }

    private void parse() {
        this.method();
        this.uri();
        this.version();
    }

    private class Token {
        public int off;
        public int len;

        private Token() {
        }
    }
}

