/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import simple.http.Header;
import simple.util.ByteStore;

final class HeaderParser {
    private Token name = new Token();
    private Token value = new Token();
    private byte[] buf;
    private int count;
    private int off;
    private int len;
    private boolean parsed = false;

    public HeaderParser(ByteStore buf) {
        this.buf = new byte[buf.length()];
        buf.getBytes(0, this.buf, 0, this.buf.length);
        this.len = this.buf.length;
        this.off = 0;
        this.count = 0;
        this.description();
    }

    public Header next() {
        if (this.hasMore()) {
            this.parsed = false;
            return new Entry(this.name, this.value, this.buf);
        }
        return null;
    }

    public boolean hasMore() {
        if (this.parsed) {
            return true;
        }
        if (this.count + 1 < this.len) {
            byte a = this.buf[this.off];
            byte b = this.buf[this.off + 1];
            if (a == 13 && b == 10) {
                return false;
            }
        }
        this.parse();
        if (this.name.len > 0) {
            this.parsed = true;
            return true;
        }
        return false;
    }

    private void description() {
        while (this.count < this.len) {
            if (this.buf[this.off] == 10) {
                ++this.count;
                ++this.off;
                break;
            }
            ++this.count;
            ++this.off;
        }
    }

    private void parse() {
        this.name();
        this.value();
    }

    private void name() {
        this.whitespace();
        this.name.off = this.off;
        this.name.len = 0;
        while (this.count < this.len) {
            if (this.buf[this.off] == 58) {
                ++this.off;
                ++this.count;
                break;
            }
            ++this.name.len;
            ++this.count;
            ++this.off;
        }
    }

    private void value() {
        this.whitespace();
        this.value.off = this.off;
        this.value.len = 0;
        int mark = 0;
        block0: while (this.count < this.len) {
            if (this.terminal(this.buf[this.off])) {
                int i = 0;
                while (this.count < this.len) {
                    if (this.buf[this.off] == 10) {
                        ++this.count;
                        ++this.off;
                        if (this.space(this.buf[this.off])) {
                            this.value.len += i;
                            continue block0;
                        }
                        return;
                    }
                    ++this.count;
                    ++this.off;
                    ++i;
                }
                continue;
            }
            if (!this.space(this.buf[this.off])) {
                this.value.len = ++mark;
            } else {
                ++mark;
            }
            ++this.count;
            ++this.off;
        }
    }

    private void whitespace() {
        while (this.count < this.len) {
            if (!this.space(this.buf[this.off])) break;
            ++this.count;
            ++this.off;
        }
    }

    private boolean space(byte b) {
        return b == 32 || b == 9;
    }

    private boolean terminal(byte b) {
        return b == 13 || b == 10;
    }

    private class Entry
    implements Header {
        private Token name;
        private Token value;
        private Cache cache;
        private String str;
        private byte[] buf;

        public Entry(Token name, Token value, byte[] buf) {
            this.name = new Token();
            this.value = new Token();
            this.cache = new Cache();
            this.name.off = name.off;
            this.name.len = name.len;
            this.value.off = value.off;
            this.value.len = value.len;
            this.buf = buf;
        }

        public String getName() {
            if (this.cache.name == null) {
                try {
                    this.cache.name = this.createName();
                }
                catch (IOException e) {
                    this.cache.name = "";
                }
            }
            return this.cache.name;
        }

        public String getValue() {
            if (this.cache.val == null) {
                try {
                    this.cache.val = this.createValue();
                }
                catch (IOException e) {
                    this.cache.val = "";
                }
            }
            return this.cache.val;
        }

        public String toString() {
            if (this.str == null) {
                this.str = String.valueOf(this.getName()) + ": " + this.getValue();
            }
            return this.str;
        }

        public boolean nameMatches(String name) {
            if (name == null) {
                return false;
            }
            if (this.name.len != name.length()) {
                return false;
            }
            if (this.cache.name != null) {
                return this.cache.name.equalsIgnoreCase(name);
            }
            int i = 0;
            while (i < this.name.len) {
                byte b;
                byte a = this.toLower(this.buf[this.name.off + i]);
                if (a != (b = this.toLower(name.charAt(i)))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private byte toLower(char c) {
            return this.toLower((byte)c);
        }

        private byte toLower(byte b) {
            if (b >= 65 && b <= 90) {
                return (byte)(b - 65 + 97);
            }
            return b;
        }

        private String createName() throws UnsupportedEncodingException {
            return new String(this.buf, this.name.off, this.name.len, "iso-8859-1");
        }

        private String createValue() throws UnsupportedEncodingException {
            return new String(this.buf, this.value.off, this.value.len, "iso-8859-1");
        }

        private class Cache {
            public String name;
            public String val;

            private Cache() {
            }
        }
    }

    private class Token {
        public int off;
        public int len;

        private Token() {
        }
    }
}

