/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.rancid;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.InventoryElement;
import org.opennms.rancid.InventoryElement2;
import org.opennms.rancid.InventoryMemory;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.InventorySoftware;
import org.opennms.rancid.RWSBucket;
import org.opennms.rancid.RWSResourceList;
import org.opennms.rancid.RWSResourceListImpl;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.rancid.RancidNodeAuthentication;
import org.opennms.rancid.Tuple;
import org.restlet.Client;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RWSClientApi {
    private static Client client = new Client(Protocol.HTTP);
    private static boolean inited = false;

    public static void init() {
        try {
            client.start();
            inited = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRWSAvailable(ConnectionProperties cp) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/";
        try {
            RWSClientApi.getMethodRWS(cp, url);
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == RancidApiException.RWS_BUSY) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public static RWSResourceList getRWSResourceList(ConnectionProperties cp, String subUri) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, subUri);
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceList(String baseUri, String subUri) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "", 30);
        return RWSClientApi.getRWSResourceList(cp, subUri);
    }

    public static RWSResourceList getRWSResourceServicesList(ConnectionProperties cp) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/");
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceServicesList(String baseUri) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSResourceServicesList(cp);
    }

    public static RWSResourceList getRWSResourceRAList(ConnectionProperties cp) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/rancid/");
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceRAList(String baseUri) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSResourceRAList(cp);
    }

    public static RWSResourceList getRWSResourceGroupsList(ConnectionProperties cp) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/rancid/groups/");
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceGroupsList(String baseUri) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSResourceGroupsList(cp);
    }

    public static RWSResourceList getRWSResourceDeviceList(ConnectionProperties cp, String group) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/rancid/groups/" + group + "/");
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceDeviceList(String baseUri, String group) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSResourceDeviceList(cp, group);
    }

    public static RWSResourceList getRWSResourceLoginPatternList(ConnectionProperties cp) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/rancid/clogin/");
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceLoginPatternList(String baseUri) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSResourceLoginPatternList(cp);
    }

    public static RWSResourceList getRWSResourceDeviceTypesPatternList(ConnectionProperties cp) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/rancid/devicetypes/");
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceDeviceTypesPatternList(String baseUri) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSResourceDeviceTypesPatternList(cp);
    }

    public static RWSResourceList getRWSResourceConfigList(ConnectionProperties cp, String group, String deviceName) throws RancidApiException {
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/rancid/groups/" + group + "/" + deviceName + "/configs/");
        return rwsImpl;
    }

    public static RWSResourceList getRWSResourceConfigList(String baseUri, String group, String deviceName) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSResourceConfigList(cp, group, deviceName);
    }

    private static List<String> getInfo(ConnectionProperties cp, String listUri) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + listUri;
        Response response = RWSClientApi.getMethodRWS(cp, url);
        DomRepresentation dmr = response.getEntityAsDom();
        ArrayList<String> data = new ArrayList<String>();
        try {
            Document doc = dmr.getDocument();
            for (int ii = 0; ii < doc.getElementsByTagName("Resource").getLength(); ++ii) {
                String tmp = doc.getElementsByTagName("Resource").item(ii).getTextContent();
                data.add(tmp);
            }
        }
        catch (IOException e) {
            throw new RancidApiException("Error: IOException Method GET: URL:" + url + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
        return data;
    }

    public static RancidNode getRWSRancidNodeTLO(ConnectionProperties cp, String group, String devicename) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + group + "/" + devicename;
        Response response = RWSClientApi.getMethodRWS(cp, url);
        DomRepresentation dmr = response.getEntityAsDom();
        RancidNode rn = new RancidNode();
        try {
            Document doc = dmr.getDocument();
            rn.setDeviceName(devicename);
            rn.setDeviceType(doc.getElementsByTagName("deviceType").item(0).getTextContent());
            rn.setStateUp(doc.getElementsByTagName("state").item(0).getTextContent().compareTo("up") == 0);
            rn.setComment(doc.getElementsByTagName("comment").item(0).getTextContent());
            rn.setGroup(group);
        }
        catch (IOException e) {
            throw new RancidApiException("Error: IOException Method GET: URL:" + url + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
        return rn;
    }

    public static RancidNode getRWSRancidNode(ConnectionProperties cp, String group, String devicename) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + group + "/" + devicename;
        Response response = RWSClientApi.getMethodRWS(cp, url);
        DomRepresentation dmr = response.getEntityAsDom();
        RancidNode rn = new RancidNode();
        try {
            Document doc1 = dmr.getDocument();
            rn.setDeviceName(devicename);
            rn.setDeviceType(doc1.getElementsByTagName("deviceType").item(0).getTextContent());
            rn.setStateUp(doc1.getElementsByTagName("state").item(0).getTextContent().compareTo("up") == 0);
            rn.setComment(doc1.getElementsByTagName("comment").item(0).getTextContent());
            rn.setGroup(group);
        }
        catch (IOException e) {
            throw new RancidApiException("Error: IOException Method GET: URL:" + url + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
        String url2 = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + group + "/" + devicename + "/configs";
        Response response2 = RWSClientApi.getMethodRWS(cp, url2);
        DomRepresentation dmr2 = response2.getEntityAsDom();
        try {
            Document doc2 = dmr2.getDocument();
            rn.setRootConfigurationUrl(doc2.getElementsByTagName("UrlViewVC").item(0).getTextContent());
            rn.setTotalRevisions(doc2.getElementsByTagName("TotalRevisions").item(0).getTextContent());
            rn.setHeadRevision(doc2.getElementsByTagName("HeadRevision").item(0).getTextContent());
        }
        catch (IOException e) {
            throw new RancidApiException("Error: IOException Method GET: URL:" + url2 + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
        return rn;
    }

    public static RancidNode getRWSRancidNode(String baseUri, String group, String devicename) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSRancidNode(cp, group, devicename);
    }

    public static void createRWSGroup(ConnectionProperties cp, String group) throws RancidApiException {
        throw new RancidApiException("Create RWS Group: operation not supported");
    }

    public static void createRWSRancidNode(ConnectionProperties cp, RancidNode rnode) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        Form form = new Form();
        form.add("deviceType", rnode.getDeviceType());
        form.add("state", rnode.getState());
        form.add("comment", rnode.getComment());
        Representation rep = form.getWebRepresentation();
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + rnode.getGroup() + "/" + rnode.getDeviceName();
        RWSClientApi.putMethodRWS(cp, url, rep);
    }

    public static void createRWSRancidNode(String baseUri, RancidNode rnode) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        RWSClientApi.createRWSRancidNode(cp, rnode);
    }

    public static void updateRWSRancidNode(ConnectionProperties cp, RancidNode rnode) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        Form form = new Form();
        form.add("deviceType", rnode.getDeviceType());
        form.add("state", rnode.getState());
        form.add("comment", rnode.getComment());
        Representation rep = form.getWebRepresentation();
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + rnode.getGroup() + "/" + rnode.getDeviceName();
        RWSClientApi.postMethodRWS(cp, url, rep);
    }

    public static void updateRWSRancidNode(String baseUri, RancidNode rnode) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        RWSClientApi.updateRWSRancidNode(cp, rnode);
    }

    public static void createOrUpdateRWSRancidNode(ConnectionProperties cp, RancidNode rnode) throws RancidApiException {
        try {
            RWSClientApi.updateRWSRancidNode(cp, rnode);
        }
        catch (RancidApiException re) {
            if (re.getRancidCode() == RancidApiException.RWS_RESOURCE_NOT_FOUND) {
                RWSClientApi.createRWSRancidNode(cp, rnode);
            }
            throw re;
        }
    }

    public static void deleteRWSRancidNode(ConnectionProperties cp, RancidNode rnode) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + rnode.getGroup() + "/" + rnode.getDeviceName();
        RWSClientApi.deleteMethodRWS(cp, url);
    }

    public static void deleteRWSRancidNode(String baseUri, RancidNode rnode) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        RWSClientApi.deleteRWSRancidNode(cp, rnode);
    }

    public static InventoryNode getRWSInventoryNode(ConnectionProperties cp, RancidNode rancidNode, String version) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + rancidNode.getGroup() + "/" + rancidNode.getDeviceName() + "/configs/" + version;
        Response response = RWSClientApi.getMethodRWS(cp, url);
        DomRepresentation dmr = response.getEntityAsDom();
        InventoryNode in = new InventoryNode(rancidNode);
        try {
            Document doc = dmr.getDocument();
            SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d H:m:s z");
            Date date = format.parse(doc.getElementsByTagName("Date").item(0).getTextContent());
            in.setCreationDate(date);
            in.setConfigurationUrl(doc.getElementsByTagName("UrlViewVC").item(0).getTextContent());
            in.setVersionId(version);
        }
        catch (IOException e) {
            throw new RancidApiException("Error: IOException Method GET: URL:" + url + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
        catch (ParseException e) {
            throw new RancidApiException("Error: ParseException Method GET: URL:" + url + " ParseException" + e, RancidApiException.OTHER_ERROR);
        }
        return in;
    }

    public static InventoryNode getRWSInventoryNode(RancidNode rancidNode, String baseUri, String version) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSInventoryNode(cp, rancidNode, version);
    }

    public static RancidNode getRWSRancidNodeInventory(ConnectionProperties cp, String group, String deviceName) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        RWSResourceList versions = RWSClientApi.getRWSResourceConfigList(cp, group, deviceName);
        RancidNode rn = RWSClientApi.getRWSRancidNode(cp, group, deviceName);
        List<String> configlist = versions.getResource();
        for (String vstmp : configlist) {
            InventoryNode in = RWSClientApi.getRWSInventoryNode(cp, rn, vstmp);
            rn.addInventoryNode(vstmp, in);
        }
        return rn;
    }

    public static RancidNode getRWSRancidNodeInventory(String baseUri, String group, String deviceName) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSRancidNodeInventory(cp, group, deviceName);
    }

    public static InventoryElement getRWSRancidNodeInventoryElement(ConnectionProperties cp, RancidNode rancidNode, String version) throws RancidApiException {
        throw new RancidApiException("Error: Api is deprecated");
    }

    public static List<InventoryElement2> getRWSRancidNodeInventoryElement2(ConnectionProperties cp, RancidNode rancidNode, String version) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/groups/" + rancidNode.getGroup() + "/" + rancidNode.getDeviceName() + "/configs/" + version + "/inventory";
        Response response = RWSClientApi.getMethodRWS(cp, url);
        DomRepresentation dmr = response.getEntityAsDom();
        ArrayList<InventoryElement2> invlist = new ArrayList<InventoryElement2>();
        try {
            Document doc = dmr.getDocument();
            for (int j = 0; j < doc.getElementsByTagName("Item").getLength(); ++j) {
                InventoryElement2 tee = new InventoryElement2();
                for (int i = 1; i < doc.getElementsByTagName("Item").item(j).getChildNodes().getLength(); ++i) {
                    Object im;
                    if (doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getNodeName().compareTo("Memory") == 0) {
                        im = new InventoryMemory();
                        ((InventoryMemory)im).setType(doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getChildNodes().item(1).getTextContent());
                        ((InventoryMemory)im).setSize(doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getChildNodes().item(3).getTextContent());
                        tee.addMemory((InventoryMemory)im);
                    } else if (doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getNodeName().compareTo("Software") == 0) {
                        im = new InventorySoftware();
                        ((InventorySoftware)im).setType(doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getChildNodes().item(1).getTextContent());
                        ((InventorySoftware)im).setVersion(doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getChildNodes().item(3).getTextContent());
                        tee.addSoftware((InventorySoftware)im);
                    } else {
                        im = new Tuple(doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getNodeName(), doc.getElementsByTagName("Item").item(j).getChildNodes().item(i).getTextContent());
                        tee.addTuple((Tuple)im);
                    }
                    ++i;
                }
                invlist.add(tee);
            }
            return invlist;
        }
        catch (IOException e) {
            throw new RancidApiException("Error getRWSRancidNodeInventoryElement: IOException Method GET: URL:" + url + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
    }

    public static RancidNodeAuthentication getRWSAuthNode(ConnectionProperties cp, String devicename) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/clogin/" + devicename;
        Response response = RWSClientApi.getMethodRWS(cp, url);
        DomRepresentation dmr = response.getEntityAsDom();
        RancidNodeAuthentication rna = new RancidNodeAuthentication();
        try {
            Document doc = dmr.getDocument();
            rna.setDeviceName(devicename);
            rna.setUser(doc.getElementsByTagName("user").item(0).getTextContent());
            rna.setPassword(doc.getElementsByTagName("password").item(0).getTextContent());
            rna.setEnablePass(doc.getElementsByTagName("enablepassword").item(0).getTextContent());
            rna.setConnectionMethod(doc.getElementsByTagName("method").item(0).getTextContent());
            try {
                rna.setAutoEnable(doc.getElementsByTagName("autoenable").item(0).getTextContent().compareTo("1") == 0);
            }
            catch (Exception e) {
                rna.setAutoEnable(false);
            }
        }
        catch (IOException e) {
            throw new RancidApiException("Error: IOException Method GET: URL:" + url + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
        return rna;
    }

    public static RancidNodeAuthentication getRWSAuthNode(String baseUri, String devicename) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        return RWSClientApi.getRWSAuthNode(cp, devicename);
    }

    public static void createRWSAuthNode(ConnectionProperties cp, RancidNodeAuthentication rnodea) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        Form form = new Form();
        form.add("user", rnodea.getUser());
        form.add("password", rnodea.getPassword());
        form.add("enablepassword", rnodea.getEnablePass());
        String autoenable = "0";
        if (rnodea.isAutoEnable()) {
            autoenable = "1";
        }
        form.add("autoenable", autoenable);
        form.add("method", rnodea.getConnectionMethodString());
        Representation rep = form.getWebRepresentation();
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/clogin/" + rnodea.getDeviceName();
        RWSClientApi.putMethodRWS(cp, url, rep);
    }

    public static void updateRWSAuthNode(ConnectionProperties cp, RancidNodeAuthentication rnodea) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        Form form = new Form();
        form.add("user", rnodea.getUser());
        form.add("password", rnodea.getPassword());
        form.add("enablepassword", rnodea.getEnablePass());
        String autoenable = "0";
        if (rnodea.isAutoEnable()) {
            autoenable = "1";
        }
        form.add("autoenable", autoenable);
        form.add("method", rnodea.getConnectionMethodString());
        Representation rep = form.getWebRepresentation();
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/clogin/" + rnodea.getDeviceName();
        RWSClientApi.postMethodRWS(cp, url, rep);
    }

    public static void createOrUpdateRWSAuthNode(ConnectionProperties cp, RancidNodeAuthentication rnodea) throws RancidApiException {
        try {
            RWSClientApi.updateRWSAuthNode(cp, rnodea);
        }
        catch (RancidApiException re) {
            if (re.getRancidCode() == RancidApiException.RWS_RESOURCE_NOT_FOUND) {
                RWSClientApi.createRWSAuthNode(cp, rnodea);
            }
            throw re;
        }
    }

    public static void createOrUpdateRWSAuthNode(String baseUri, RancidNodeAuthentication rnodea) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        RWSClientApi.createOrUpdateRWSAuthNode(cp, rnodea);
    }

    public static void deleteRWSAuthNode(ConnectionProperties cp, RancidNodeAuthentication rnodea) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/rancid/clogin/" + rnodea.getDeviceName();
        RWSClientApi.deleteMethodRWS(cp, url);
    }

    public static void deleteRWSAuthNode(String baseUri, RancidNodeAuthentication rnodea) throws RancidApiException {
        ConnectionProperties cp = new ConnectionProperties("", "", baseUri, "/rws", 30);
        RWSClientApi.deleteRWSAuthNode(cp, rnodea);
    }

    public static RWSResourceList getBuckets(ConnectionProperties cp) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        RWSResourceListImpl rwsImpl = new RWSResourceListImpl();
        rwsImpl.ResourcesList = RWSClientApi.getInfo(cp, "/storage/buckets/");
        return rwsImpl;
    }

    public static RWSBucket getBucket(ConnectionProperties cp, String bucketName) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/storage/buckets/" + bucketName;
        Response response = RWSClientApi.getMethodRWS(cp, url);
        DomRepresentation dmr = response.getEntityAsDom();
        RWSBucket bucket = new RWSBucket(bucketName);
        try {
            Document doc = dmr.getDocument();
            int fileNumber = doc.getElementsByTagName("File").getLength();
            bucket.setBucketItem(new ArrayList<RWSBucket.BucketItem>(fileNumber));
            for (int j = 0; j < fileNumber; ++j) {
                String itemName = "";
                int itemSize = 0;
                Date itemDate = null;
                for (int i = 0; i < doc.getElementsByTagName("File").item(j).getChildNodes().getLength(); ++i) {
                    RWSClientApi.log().debug((Object)("Item:" + i + " NodeName: " + doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getNodeName()));
                    RWSClientApi.log().debug((Object)("Item:" + i + " NodeTextContent: " + doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getTextContent()));
                    if ("Name".equals(doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getNodeName())) {
                        itemName = doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getTextContent();
                        continue;
                    }
                    if ("Size".equals(doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getNodeName())) {
                        itemSize = Integer.parseInt(doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getTextContent());
                        continue;
                    }
                    if (!"LastModified".equals(doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getNodeName())) continue;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/M/d H:m:s z");
                    itemDate = format.parse(doc.getElementsByTagName("File").item(j).getChildNodes().item(i).getTextContent());
                }
                bucket.setBucket(j, itemName, itemSize, itemDate);
            }
        }
        catch (IOException e) {
            throw new RancidApiException("Error: IOException Method GET: URL:" + url + ":" + e.getMessage(), RancidApiException.OTHER_ERROR);
        }
        catch (ParseException pe) {
            throw new RancidApiException("Error: ParseException Method GET: URL:" + url + ":" + pe.getMessage(), RancidApiException.OTHER_ERROR);
        }
        return bucket;
    }

    public static byte[] getBucketItem(ConnectionProperties cp, String bucketName, String filename) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/storage/buckets/" + bucketName + "?filename=" + filename;
        Response response = RWSClientApi.getMethodRWS(cp, url);
        response.getEntity();
        throw new RancidApiException("getBucketItem: not implemented");
    }

    public static void createBucket(ConnectionProperties cp, String bucketName) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/storage/buckets/" + bucketName;
        RWSClientApi.putMethodRWS(cp, url, new Form().getWebRepresentation());
    }

    public static void deleteBucket(ConnectionProperties cp, String bucketName) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/storage/buckets/" + bucketName;
        RWSClientApi.deleteMethodRWS(cp, url);
    }

    public static void updateBucket(ConnectionProperties cp, String bucketName, String fileName, InputStream io) throws RancidApiException {
        throw new RancidApiException("updateBucket: Not implemented");
    }

    public static void deleteBucketItem(ConnectionProperties cp, String bucketName, String fileName) throws RancidApiException {
        if (!inited) {
            throw new RancidApiException("Error: Api not initialized");
        }
        String url = cp.getUrl() + cp.getDirectory() + "/storage/buckets/" + bucketName + "?filename=" + fileName;
        RWSClientApi.deleteMethodRWS(cp, url);
    }

    static Response getMethodRWS(ConnectionProperties cp, String uriReference) throws RancidApiException {
        Response response;
        client.setConnectTimeout(cp.getTimeout());
        Request request = new Request(Method.GET, uriReference);
        if (cp.getUserName() != null) {
            ChallengeScheme scheme = ChallengeScheme.HTTP_BASIC;
            ChallengeResponse authentication = new ChallengeResponse(scheme, cp.getUserName(), cp.getPassword());
            request.setChallengeResponse(authentication);
        }
        if ((response = client.handle(request)).getStatus().isSuccess()) {
            return response;
        }
        throw RWSClientApi.handleException(response, "GET", uriReference);
    }

    static Response postMethodRWS(ConnectionProperties cp, String uriReference, Representation form) throws RancidApiException {
        Response response;
        client.setConnectTimeout(cp.getTimeout());
        Request request = new Request(Method.POST, uriReference, form);
        if (cp.getAuthOn()) {
            ChallengeScheme scheme = ChallengeScheme.HTTP_BASIC;
            ChallengeResponse authentication = new ChallengeResponse(scheme, cp.getUserName(), cp.getPassword());
            request.setChallengeResponse(authentication);
        }
        if ((response = client.handle(request)).getStatus().isSuccess()) {
            return response;
        }
        throw RWSClientApi.handleException(response, "POST", uriReference);
    }

    static Response putMethodRWS(ConnectionProperties cp, String uriReference, Representation form) throws RancidApiException {
        Response response;
        client.setConnectTimeout(cp.getTimeout());
        Request request = new Request(Method.PUT, uriReference, form);
        if (cp.getAuthOn()) {
            ChallengeScheme scheme = ChallengeScheme.HTTP_BASIC;
            ChallengeResponse authentication = new ChallengeResponse(scheme, cp.getUserName(), cp.getPassword());
            request.setChallengeResponse(authentication);
        }
        if ((response = client.handle(request)).getStatus().isSuccess()) {
            return response;
        }
        throw RWSClientApi.handleException(response, "PUT", uriReference);
    }

    static Response deleteMethodRWS(ConnectionProperties cp, String uriReference) throws RancidApiException {
        Response response;
        client.setConnectTimeout(cp.getTimeout());
        Request request = new Request(Method.DELETE, uriReference);
        if (cp.getAuthOn()) {
            ChallengeScheme scheme = ChallengeScheme.HTTP_BASIC;
            ChallengeResponse authentication = new ChallengeResponse(scheme, cp.getUserName(), cp.getPassword());
            request.setChallengeResponse(authentication);
        }
        if ((response = client.handle(request)).getStatus().isSuccess()) {
            return response;
        }
        throw RWSClientApi.handleException(response, "DELETE", uriReference);
    }

    static RancidApiException handleException(Response response, String method, String uriReference) throws RancidApiException {
        if (response.getStatus() == Status.CLIENT_ERROR_REQUEST_TIMEOUT) {
            return new RancidApiException("Error: RWS " + method + " failed for URL:" + uriReference + " Status: " + response.getStatus(), RancidApiException.RWS_TIMEOUT);
        }
        if (response.getStatus() == Status.CLIENT_ERROR_UNAUTHORIZED) {
            return new RancidApiException("Error: RWS " + method + " failed for URL:" + uriReference + " Status: " + response.getStatus(), RancidApiException.RWS_AUTH_FAILES);
        }
        if (response.getStatus().getCode() == 404) {
            return new RancidApiException("Error: RWS " + method + " failed for URL:" + uriReference + " Status: " + response.getStatus(), RancidApiException.RWS_RESOURCE_NOT_FOUND);
        }
        if (response.getStatus().getCode() == 409) {
            return new RancidApiException("Error: RWS " + method + " failed for URL:" + uriReference + " Status: " + response.getStatus(), RancidApiException.RWS_RESOURCE_EXISTS);
        }
        if (response.getStatus().getCode() == 503) {
            return new RancidApiException("Error: RWS " + method + " failed for URL:" + uriReference + " Status: " + response.getStatus(), RancidApiException.RWS_BUSY);
        }
        return new RancidApiException("Error: RWS " + method + " failed for URL: " + uriReference + " Status: " + response.getStatus(), RancidApiException.OTHER_ERROR);
    }

    private static Category log() {
        return Logger.getLogger((String)"Rancid");
    }
}

