/*
 * Decompiled with CFR 0.152.
 */
package simple.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import simple.util.ByteStore;

public final class Buffer
implements ByteStore {
    private byte[] buf = null;
    private int count = 0;

    public Buffer() {
        this(16);
    }

    public Buffer(int size) {
        this.buf = new byte[size];
    }

    public Buffer(byte[] b) {
        this(b, 0, b.length);
    }

    public Buffer(Buffer buf) {
        this(buf.buf, 0, buf.count);
    }

    public Buffer(byte[] b, int off, int len) {
        this.buf = new byte[len];
        this.count = 0;
        this.append(b, off, len);
    }

    public Buffer(Buffer buf, int off, int len) {
        this.buf = new byte[len];
        this.count = 0;
        this.append(buf, off, len);
    }

    public void append(int b) {
        if (this.count >= this.buf.length) {
            this.resize(this.buf.length + 1);
        }
        this.buf[this.count++] = (byte)b;
    }

    public void append(byte[] b) {
        if (b.length + this.count > this.buf.length) {
            this.resize(b.length + this.count);
        }
        System.arraycopy(b, 0, this.buf, this.count, b.length);
        this.count += b.length;
    }

    public void append(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len + this.count > this.buf.length) {
            this.resize(this.count + len);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void append(Buffer buf) {
        this.append(buf.buf, 0, buf.count);
    }

    public void append(Buffer buf, int off, int len) {
        if (off + len > buf.count) {
            throw new IndexOutOfBoundsException();
        }
        this.append(buf.buf, off, len);
    }

    public void insert(int pos, int b) {
        if (pos < 0 || pos >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count + 1 > this.buf.length) {
            this.resize(this.count + 1);
        }
        System.arraycopy(this.buf, pos, this.buf, pos + 1, this.count - pos);
        this.buf[pos] = (byte)b;
    }

    public void insert(int pos, byte[] b) {
        if (pos < 0 || pos >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count + b.length > this.buf.length) {
            this.resize(this.count + b.length);
        }
        System.arraycopy(this.buf, pos, this.buf, pos + b.length, b.length);
        System.arraycopy(this.buf, pos, b, 0, b.length);
    }

    public void insert(int pos, byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (pos >= this.count || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count + len > this.buf.length) {
            this.resize(this.count + len);
        }
        System.arraycopy(this.buf, pos, this.buf, pos + len, len);
        System.arraycopy(this.buf, pos, b, off, len);
    }

    public void insert(int pos, Buffer buf) {
        this.insert(pos, buf.buf, 0, buf.count);
    }

    public void insert(int pos, Buffer buf, int off, int len) {
        if (off + len > buf.count) {
            throw new IndexOutOfBoundsException();
        }
        this.insert(pos, buf.buf, off, len);
    }

    public void delete(int pos) {
        if (pos >= this.count || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, pos + 1, this.buf, pos, this.count - pos + 1);
        --this.count;
    }

    public void delete(int pos, int len) {
        if (pos > this.count || pos + len > this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (pos < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, pos + len, this.buf, pos, this.count - pos + len);
        this.count -= len;
    }

    public boolean regionMatches(int pos, byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (pos + len > this.count || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i = len + off;
        while (off < i) {
            if (this.buf[pos++] != b[off]) {
                return false;
            }
            ++off;
        }
        return true;
    }

    public boolean regionMatches(int pos, Buffer buf, int off, int len) {
        if (off + len > buf.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.regionMatches(pos, buf.buf, off, len);
    }

    public boolean equals(Buffer buf) {
        if (buf.count != this.count) {
            return false;
        }
        return this.regionMatches(0, buf.buf, 0, this.count);
    }

    public void setByte(int pos, int b) {
        if (pos >= this.count || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.buf[pos] = (byte)b;
    }

    public void setBytes(int pos, byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (pos >= this.count || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(b, off, this.buf, pos, len);
    }

    public void setBytes(int pos, Buffer buf) {
        this.setBytes(pos, buf.buf, 0, buf.count);
    }

    public void setBytes(int pos, Buffer buf, int off, int len) {
        if (pos + off > buf.count) {
            throw new IndexOutOfBoundsException();
        }
        this.setBytes(pos, buf.buf, off, len);
    }

    public byte getByte(int pos) {
        if (pos >= this.count || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[pos];
    }

    public void getBytes(int pos, byte[] b) {
        this.getBytes(pos, b, 0, b.length);
    }

    public void getBytes(int pos, byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (pos + len > this.count || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, pos, b, off, len);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream out, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > this.count) {
            throw new IndexOutOfBoundsException();
        }
        out.write(this.buf, off, len);
    }

    public void resize(int min) {
        if (this.buf.length < min) {
            int size = this.buf.length * 2;
            int max = min > size ? min : size;
            byte[] temp = new byte[max];
            System.arraycopy(this.buf, 0, temp, 0, this.count);
            this.buf = temp;
        }
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public byte[] toArray() {
        byte[] copy = new byte[this.count];
        System.arraycopy(this.buf, 0, copy, 0, this.count);
        return copy;
    }

    public void clear() {
        this.count = 0;
    }

    public int capacity() {
        return this.buf.length;
    }

    public int length() {
        return this.count;
    }

    public String toString() {
        try {
            return new String(this.buf, 0, this.count, "UTF-8");
        }
        catch (IOException iOException) {
            return new String(this.buf, 0, this.count);
        }
    }
}

