/*
 * Decompiled with CFR 0.152.
 */
package simple.http.session;

import java.util.HashSet;
import java.util.Set;
import simple.http.session.Module;
import simple.http.session.Session;
import simple.http.session.Store;
import simple.http.session.StoreException;
import simple.util.lease.Lease;
import simple.util.lease.LeaseException;
import simple.util.net.Cookie;

final class Delegate
implements Session {
    private Store store;
    private Lease lease;

    public Delegate(Module module, Cookie cookie) {
        this.store = module.getStore();
        this.lease = module.getLease();
    }

    public Object get(String name) {
        try {
            return this.store.get(name);
        }
        catch (StoreException e) {
            return null;
        }
    }

    public void put(String name, Object value) {
        try {
            this.store.put(name, value);
        }
        catch (StoreException e) {
            return;
        }
    }

    public boolean contains(String name) {
        try {
            return this.store.contains(name);
        }
        catch (StoreException e) {
            return false;
        }
    }

    public void remove(String name) {
        try {
            this.store.remove(name);
        }
        catch (StoreException e) {
            return;
        }
    }

    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    public Set keySet() {
        try {
            return this.store.keySet();
        }
        catch (StoreException e) {
            return new HashSet();
        }
    }

    public void destroy() {
        try {
            this.lease.cancel();
        }
        catch (LeaseException e) {
            return;
        }
    }
}

