/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.File;
import java.io.IOException;
import simple.http.serve.Context;
import simple.http.serve.Format;
import simple.http.serve.FormatException;
import simple.http.serve.Report;

final class DefaultFormat
implements Format {
    DefaultFormat() {
    }

    public byte[] getContents(Context context, String target) throws FormatException {
        if (!context.getFile(target).isDirectory()) {
            throw new FormatException("No format available");
        }
        String fixed = target;
        if (fixed.indexOf(63) > 0) {
            fixed = fixed.substring(0, fixed.indexOf(47) + 1);
        }
        if (fixed.lastIndexOf(59) > 0) {
            fixed = fixed.substring(0, fixed.indexOf(59) + 1);
        }
        return this.getContents(context, target, !fixed.endsWith("/") && !fixed.endsWith("/."));
    }

    private byte[] getContents(Context context, String target, boolean isRelative) {
        String path = isRelative ? String.valueOf(context.getName(target)) + "/" : "";
        File directory = context.getFile(target);
        String index = context.getRequestPath(target);
        String[] names = directory.list();
        String text = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n<HTML><HEAD><TITLE>Index of " + index + "</TITLE>\n" + "</HEAD><BODY>" + "<H1>Index of " + index + "</H1>\n" + "<HR><TABLE>" + "<TR><TD><B>Name</B></TD>" + "<TD><B>Size</B></TD>" + "<TD><B>Type</B></TD></TR>\n";
        int i = 0;
        while (i < names.length) {
            File file = new File(directory, names[i]);
            boolean isDirectory = file.isDirectory();
            String name = String.valueOf(names[i]) + (isDirectory ? "/" : "");
            String size = isDirectory ? "-" : "" + file.length();
            String mime = isDirectory ? "text/html" : context.getContentType("/" + name);
            text = String.valueOf(text) + "<TR><TD><TT><A HREF=\"" + path + name + "\">" + name + "</A></TT></TD>" + "<TD><TT>" + size + "</TT></TD><TD><TT>" + mime + "</TT></TD></TR>\n";
            ++i;
        }
        return this.getBytes(String.valueOf(text) + "</TABLE><HR>" + "</BODY></HTML>");
    }

    public byte[] getMessage(Context context, String target, Report report) {
        return this.getBytes("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n<HTML><HEAD><TITLE>" + report.getCode() + " " + report.getText() + "</TITLE>\n" + "</HEAD><BODY><H1>" + report.getText() + "</H1>" + "<PRE>The requested URL <i>" + target + "</i></PRE>" + "<HR><PRE>" + report.getCause() + "</PRE></BODY></HTML>");
    }

    private byte[] getBytes(String text) {
        try {
            return text.getBytes("utf-8");
        }
        catch (IOException never) {
            return null;
        }
    }

    public String getContentType() {
        return "text/html; charset=utf-8";
    }
}

