/*
 * Decompiled with CFR 0.152.
 */
package simple.util.parse;

import simple.util.PriorityQueue;
import simple.util.parse.Parser;

public class ListParser
extends Parser {
    private PriorityQueue queue = new PriorityQueue();
    private String[] list;
    private char[] text = new char[0];
    private int qvalue;
    private int start;
    private int pos;

    public ListParser() {
    }

    public ListParser(String text) {
        this();
        this.parse(text);
    }

    public ListParser(String[] list) {
        this();
        this.parse(list);
    }

    public void parse(String[] list) {
        int i = 0;
        while (i < list.length) {
            this.parse(list[i]);
            ++i;
        }
    }

    public String[] list() {
        if (this.list == null) {
            this.build();
        }
        return this.list;
    }

    private void build() {
        this.list = new String[this.queue.length()];
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = (String)this.queue.remove();
            ++i;
        }
    }

    protected void parse() {
        while (this.off < this.count) {
            this.clear();
            this.value();
            this.save();
        }
    }

    protected void init() {
        if (this.text.length < this.count) {
            this.text = new char[this.count];
        }
        this.off = 0;
        this.pos = 0;
        this.list = null;
        this.start = 10000;
    }

    private void clear() {
        this.qvalue = this.start--;
        this.pos = 0;
    }

    private void value() {
        block0: while (this.off < this.count) {
            if (this.buf[this.off++] == '\"') {
                this.text[this.pos++] = this.buf[this.off - 1];
                while (++this.off < this.count) {
                    if (this.buf[this.off - 1] != '\"' || this.buf[this.off - 2] == '\\') {
                        this.text[this.pos++] = this.buf[this.off - 1];
                        continue;
                    }
                    break;
                }
            } else if (this.buf[this.off - 1] == ';') {
                int seek = this.off;
                while (seek + 1 < this.count) {
                    if (!this.space(this.buf[seek])) {
                        if (this.buf[seek] == 'q' && this.buf[seek + 1] == '=') {
                            this.off = seek;
                            this.qvalue();
                            continue block0;
                        }
                        break;
                    }
                    ++seek;
                }
            }
            if (this.buf[this.off - 1] == ',') break;
            this.text[this.pos++] = this.buf[this.off - 1];
        }
    }

    private void save() {
        int size = this.pos;
        int start = 0;
        while (size > 0) {
            if (!this.space(this.text[size - 1])) break;
            --size;
        }
        while (start < this.pos) {
            if (!this.space(this.text[start])) break;
            ++start;
            --size;
        }
        if (size > 0) {
            this.save(start, size);
        }
    }

    private void save(int start, int len) {
        this.save(new String(this.text, start, len));
    }

    private void save(String text) {
        if (this.qvalue > 0) {
            this.queue.add(text, this.qvalue);
        }
    }

    private void qvalue() {
        this.qvalue = 0;
        if (this.skip("q=")) {
            int value = this.start;
            int digit = 0;
            while (this.off < this.count) {
                if (this.buf[this.off] == '.') {
                    ++this.off;
                    continue;
                }
                if (this.digit(this.buf[this.off])) {
                    digit = this.buf[this.off];
                    digit -= 48;
                    this.qvalue += (digit *= (value /= 10));
                    ++this.off;
                    continue;
                }
                break;
            }
        } else {
            this.qvalue = this.start;
        }
    }
}

