/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.rancid;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.opennms.rancid.Message;
import org.opennms.rancid.RWS_MT_ClientApi;

class RetryThread
extends Thread {
    static ConcurrentLinkedQueue retryBuffer;
    RWS_MT_ClientApi mt;
    private int sleepTime = 10000;
    private static boolean singleton;
    private static RetryThread instance;

    private RetryThread() {
    }

    public static RetryThread getInstance() {
        if (instance == null) {
            instance = new RetryThread();
        }
        return instance;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void init(RWS_MT_ClientApi mt) {
        System.out.println("RetryThread.init()");
        this.mt = mt;
        retryBuffer = new ConcurrentLinkedQueue();
        Message m = new Message(RWS_MT_ClientApi.TOKEN);
        retryBuffer.add(m);
    }

    public void run() {
        System.out.println("RetryThread.run() called");
        while (true) {
            System.out.println("RetryThread.run() loop");
            Message x = (Message)retryBuffer.poll();
            if (x.getOperation() == RWS_MT_ClientApi.TOKEN) {
                retryBuffer.add(x);
                System.out.println("RetryThread.run() token found");
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    System.out.println(e.getMessage());
                }
                continue;
            }
            System.out.println("RetryThread.run() message found " + x.getRancidNode().getDeviceName());
            long i = System.currentTimeMillis();
            System.out.println("RetryThread.run() message found timestamp " + x.getTimestamp() + " current " + i);
            if (x.getTimestamp() <= i) {
                System.out.println("RetryThread.run() message rescheduled");
                RWS_MT_ClientApi.reDoWork(x);
                continue;
            }
            System.out.println("RetryThread.run() message delayed");
            retryBuffer.add(x);
        }
    }

    public void putMessage(Message m) {
        retryBuffer.add(m);
    }

    static {
        singleton = false;
    }
}

