/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Range;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeUtils {
    public static String formatContentRange(Range range, long size) throws Exception {
        StringBuilder b = new StringBuilder("bytes ");
        if (range.getIndex() >= 0L) {
            b.append(range.getIndex());
            b.append("-");
            if (range.getSize() != -1L) {
                b.append(range.getIndex() + range.getSize());
            } else if (size != -1L) {
                b.append(range.getIndex() + size);
            }
        } else if (range.getIndex() == -1L) {
            if (range.getSize() != -1L) {
                if (size != -1L) {
                    b.append(size - range.getSize());
                    b.append("-");
                    b.append(size);
                } else {
                    b.append("-");
                    b.append(range.getSize());
                }
            } else {
                throw new IllegalArgumentException("The range provides no index and no size, it is invalid.");
            }
        }
        if (size != -1L) {
            b.append("/").append(size);
        } else {
            b.append("/*");
        }
        return b.toString();
    }

    public static String formatRanges(List<Range> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        StringBuilder value = new StringBuilder("bytes=");
        for (int i = 0; i < ranges.size(); ++i) {
            Range range = ranges.get(i);
            if (i > 0) {
                value.append(", ");
            }
            if (range.getIndex() >= 0L) {
                value.append(range.getIndex());
                value.append("-");
                if (range.getSize() == -1L) continue;
                value.append(range.getIndex() + range.getSize());
                continue;
            }
            if (range.getIndex() != -1L) continue;
            value.append("-");
            if (range.getSize() == -1L) continue;
            value.append(range.getSize());
        }
        return value.toString();
    }

    public static void parseContentRange(String value, Representation representation) {
        String prefix = "bytes ";
        if (value != null && value.startsWith(prefix)) {
            value = value.substring(prefix.length());
            int index = value.indexOf("-");
            int index1 = value.indexOf("/");
            int startIndex = Integer.parseInt(value.substring(0, index));
            int endIndex = Integer.parseInt(value.substring(index + 1, index1));
            String strLength = value.substring(index1 + 1, value.length());
            representation.setRange(new Range(startIndex, endIndex - startIndex));
            if (!"*".equals(strLength)) {
                representation.setSize(Long.parseLong(strLength));
            }
        }
    }

    public static List<Range> parseRangeHeader(String rangeHeader) {
        ArrayList<Range> result = new ArrayList<Range>();
        String prefix = "bytes=";
        if (rangeHeader != null && rangeHeader.startsWith(prefix)) {
            rangeHeader = rangeHeader.substring(prefix.length());
            String[] array = rangeHeader.split(",");
            for (int i = 0; i < array.length; ++i) {
                String value = array[i].trim();
                long index = 0L;
                long length = 0L;
                if (value.startsWith("-")) {
                    index = -1L;
                    length = Long.parseLong(value.substring(1));
                } else if (value.endsWith("-")) {
                    index = Long.parseLong(value.substring(0, value.length() - 1));
                    length = -1L;
                } else {
                    String[] tab = value.split("-");
                    if (tab.length == 2) {
                        index = Long.parseLong(tab[0]);
                        length = Long.parseLong(tab[1]) - index;
                    }
                }
                result.add(new Range(index, length));
            }
        }
        return result;
    }
}

