/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.restlet.data.Range;

public class RangeInputStream
extends FilterInputStream {
    private long position;
    private Range range;
    private long totalSize;

    protected RangeInputStream(InputStream in, long totalSize, Range range) {
        super(in);
        this.range = range;
        this.position = 0L;
        this.totalSize = totalSize;
    }

    public int available() throws IOException {
        return super.available();
    }

    public synchronized void mark(int readlimit) {
        if (this.range.getIndex() == -1L) {
            super.mark(readlimit + (int)(this.totalSize - this.range.getSize()));
        } else {
            super.mark(readlimit + (int)this.range.getIndex());
        }
    }

    public int read() throws IOException {
        int result = super.read();
        while (result != -1 && !this.range.isIncluded(this.position++, this.totalSize)) {
            result = super.read();
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long startIndex = this.range.getIndex() != -1L ? this.range.getIndex() : this.totalSize - this.range.getSize();
        long skipped = this.skip(startIndex - this.position);
        while (skipped >= 0L && this.position < startIndex && !this.range.isIncluded(this.position += skipped, this.totalSize)) {
            skipped = this.skip(startIndex - this.position);
        }
        if (this.range.getSize() != -1L) {
            long finalIndex = startIndex + this.range.getSize();
            if (this.position >= finalIndex) {
                return -1;
            }
            int n = super.read(b, off, this.position + (long)len > finalIndex ? (int)(finalIndex - this.position) : len);
            if (n > 0) {
                this.position += (long)n;
            }
            return n;
        }
        return super.read(b, off, len);
    }
}

