/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet;

import com.noelios.restlet.LogFilter;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.service.LogService;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChainHelper<T extends Restlet>
extends Helper<T> {
    private volatile Restlet first = null;
    private volatile Filter last;

    public ChainHelper(T helped) {
        super(helped);
    }

    protected synchronized void addFilter(Filter filter) {
        if (this.getLast() != null) {
            this.getLast().setNext(filter);
            this.setLast(filter);
        } else {
            this.setFirst(filter);
            this.setLast(filter);
        }
    }

    public void clear() {
        this.setFirst(null);
        this.setNext(null);
    }

    protected Filter createLogFilter(Context context, LogService logService) {
        return new LogFilter(context, logService);
    }

    protected Restlet getFirst() {
        return this.first;
    }

    protected Filter getLast() {
        return this.last;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getFirst() != null) {
            this.getFirst().handle(request, response);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            ((Restlet)this.getHelped()).getLogger().log(Level.SEVERE, "The " + this.getHelped().getClass().getName() + " class has no Restlet defined to process calls. Maybe it wasn't properly started.");
        }
    }

    protected void setFirst(Restlet first) {
        this.first = first;
    }

    protected void setLast(Filter last) {
        this.last = last;
    }

    protected synchronized void setNext(Restlet next) {
        if (this.getFirst() == null) {
            this.setFirst(next);
        } else {
            this.getLast().setNext(next);
        }
    }
}

