/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.opennms.core.utils.ExecRunner;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.ALL})
public final class SystemExecuteMonitor
extends AbstractServiceMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemExecuteMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String script = ParameterMap.getKeyedString(parameters, (String)"script", null);
        String problem = this.checkScriptFile(script);
        if (problem != null) {
            LOGGER.error(problem);
            return PollStatus.unknown((String)problem);
        }
        String args = ParameterMap.getKeyedString(parameters, (String)"args", (String)"");
        args = this.enrichArguments(args, svc, tracker, parameters);
        String strBannerMatch = (String)parameters.get("banner");
        String scriptOutput = "";
        String scriptError = "";
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            try {
                String reason;
                tracker.startAttempt();
                int exitStatus = 100;
                int timeoutInSeconds = (int)tracker.getTimeoutInSeconds();
                ExecRunner execRunner = new ExecRunner();
                execRunner.setMaxRunTimeSecs(timeoutInSeconds);
                LOGGER.debug("calling: " + script + " " + args);
                exitStatus = execRunner.exec(script + " " + args);
                double responseTime = tracker.elapsedTimeInMillis();
                if (exitStatus != 0) {
                    scriptOutput = execRunner.getOutString();
                    reason = script + " failed with exit code " + exitStatus + ". Standard out: " + scriptOutput;
                    LOGGER.debug(reason);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                if (execRunner.isMaxRunTimeExceeded()) {
                    reason = script + " failed. Timeout exceeded";
                    LOGGER.debug(reason);
                    serviceStatus = PollStatus.unavailable((String)reason);
                } else if (exitStatus == 0) {
                    scriptOutput = execRunner.getOutString();
                    scriptError = execRunner.getErrString();
                    if (!scriptOutput.equals("")) {
                        LOGGER.debug("{} output  = {}", (Object)script, (Object)scriptOutput);
                    } else {
                        LOGGER.debug("{} returned no output", (Object)script);
                    }
                    if (!scriptError.equals("")) {
                        LOGGER.debug("{} error = {}", (Object)script, (Object)scriptError);
                    }
                    serviceStatus = strBannerMatch == null || strBannerMatch.equals("*") ? PollStatus.available((Double)responseTime) : (scriptOutput.indexOf(strBannerMatch) > -1 ? PollStatus.available((Double)responseTime) : PollStatus.unavailable((String)(script + " banner not contained in output banner='" + strBannerMatch + "' output='" + scriptOutput + "'")));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String reason = script + " ArrayIndexOutOfBoundsException";
                LOGGER.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (IOException e) {
                String reason = "IOException occurred. Check for proper operation of " + script;
                LOGGER.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (InterruptedException e) {
                LOGGER.debug("Interruption for script " + script, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)("Interruption for script " + script + " " + e.getMessage()));
            }
            tracker.nextAttempt();
        }
        LOGGER.debug("Called: '" + script + " " + args + "' Result: " + serviceStatus + " ResponseTime: " + serviceStatus.getResponseTime());
        return serviceStatus;
    }

    private String enrichArguments(String args, MonitoredService svc, TimeoutTracker tracker, Map<String, Object> parameters) {
        String richArgs = args;
        richArgs = richArgs.replace("${timeout}", Long.valueOf(tracker.getTimeoutInMillis()).toString());
        richArgs = richArgs.replace("${timeoutsec}", Long.valueOf(tracker.getTimeoutInSeconds()).toString());
        richArgs = richArgs.replace("${retry}", ParameterMap.getKeyedString(parameters, (String)"retry", (String)Integer.valueOf(0).toString()));
        richArgs = richArgs.replace("${ipaddr}", svc.getIpAddr());
        richArgs = richArgs.replace("${nodeid}", Integer.valueOf(svc.getNodeId()).toString());
        richArgs = richArgs.replace("${nodelabel}", svc.getNodeLabel());
        richArgs = richArgs.replace("${svcname}", svc.getSvcName());
        return richArgs;
    }

    private String checkScriptFile(String script) {
        if (script == null) {
            return "required parameter script not found";
        }
        File scriptFile = new File(script);
        if (!scriptFile.exists()) {
            return "Script file dose not exist: " + script;
        }
        return null;
    }
}

