/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class SmtpMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(SmtpMonitor.class);
    private static final int DEFAULT_PORT = 25;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String LOCALHOST_NAME = InetAddressUtils.getLocalHostName();
    private static final RE MULTILINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)25);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("poll: address = {}, port = {}, {}", new Object[]{hostAddress, port, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            block65: {
                String reason;
                Socket socket = null;
                try {
                    tracker.startAttempt();
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(ipAddr, port), tracker.getConnectionTimeout());
                    socket.setSoTimeout(tracker.getSoTimeout());
                    LOG.debug("SmtpMonitor: connected to host: {} on port: {}", (Object)ipAddr, (Object)port);
                    serviceStatus = PollStatus.unresponsive();
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream(), "ASCII"));
                    String banner = rdr.readLine();
                    if (banner == null) break block65;
                    if (MULTILINE.match(banner)) {
                        String multiLineRC = new String(banner.getBytes("ASCII"), 0, 3, "ASCII");
                        RE endMultiline = null;
                        try {
                            endMultiline = new RE(multiLineRC);
                        }
                        catch (RESyntaxException ex) {
                            throw new UndeclaredThrowableException(ex);
                        }
                        while ((banner = rdr.readLine()) != null && !endMultiline.match(banner)) {
                        }
                        if (banner == null) break block65;
                    }
                    LOG.debug("poll: banner = {}", (Object)banner);
                    StringTokenizer t = new StringTokenizer(banner);
                    int rc = Integer.parseInt(t.nextToken());
                    if (rc == 220) {
                        RE endMultiline;
                        String multiLineRC;
                        String cmd = "HELO " + LOCALHOST_NAME + "\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        String response = rdr.readLine();
                        double responseTime = tracker.elapsedTimeInMillis();
                        if (response == null) break block65;
                        if (MULTILINE.match(response)) {
                            multiLineRC = new String(response.getBytes("ASCII"), 0, 3, "ASCII");
                            endMultiline = null;
                            try {
                                endMultiline = new RE(multiLineRC);
                            }
                            catch (RESyntaxException ex) {
                                throw new UndeclaredThrowableException(ex);
                            }
                            while ((response = rdr.readLine()) != null && !endMultiline.match(response)) {
                            }
                            if (response == null) break block65;
                        }
                        if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 250) {
                            cmd = "QUIT\r\n";
                            socket.getOutputStream().write(cmd.getBytes("ASCII"));
                            response = rdr.readLine();
                            if (response == null) break block65;
                            if (MULTILINE.match(response)) {
                                multiLineRC = new String(response.getBytes("ASCII"), 0, 3, "ASCII");
                                endMultiline = null;
                                try {
                                    endMultiline = new RE(multiLineRC);
                                }
                                catch (RESyntaxException ex) {
                                    throw new UndeclaredThrowableException(ex);
                                }
                                while ((response = rdr.readLine()) != null && !endMultiline.match(response)) {
                                }
                                if (response == null) break block65;
                            }
                            if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 221) {
                                serviceStatus = PollStatus.available((Double)responseTime);
                            }
                        }
                    }
                    if (!serviceStatus.isAvailable()) {
                        serviceStatus = PollStatus.unavailable();
                    }
                }
                catch (NumberFormatException e) {
                    reason = "NumberFormatException while polling address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (NoRouteToHostException e) {
                    reason = "No route to host exception for address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                    break;
                }
                catch (InterruptedIOException e) {
                    reason = "Did not receive expected response within timeout " + tracker;
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (ConnectException e) {
                    reason = "Unable to connect to address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (IOException e) {
                    reason = "IOException while polling address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        LOG.debug("poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    static {
        try {
            MULTILINE = new RE("^[0-9]{3}-");
        }
        catch (RESyntaxException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

