/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.DefaultSocketWrapper;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketWrapper;
import org.opennms.core.utils.TimeoutSocketFactory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class LdapMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(LdapMonitor.class);
    private static final int DEFAULT_RETRY = 1;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String DEFAULT_BASE = "base";
    private static final String DEFAULT_FILTER = "(objectclass=*)";

    protected SocketWrapper getSocketWrapper() {
        return new DefaultSocketWrapper();
    }

    protected int determinePort(Map<String, Object> parameters) {
        return ParameterMap.getKeyedInteger(parameters, (String)"port", (int)389);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        int serviceStatus = 2;
        String reason = null;
        TimeoutTracker tracker = new TimeoutTracker(parameters, 1, 3000);
        int ldapVersion = ParameterMap.getKeyedInteger(parameters, (String)"version", (int)3);
        int ldapPort = this.determinePort(parameters);
        String searchBase = ParameterMap.getKeyedString(parameters, (String)"searchbase", (String)DEFAULT_BASE);
        String searchFilter = ParameterMap.getKeyedString(parameters, (String)"searchfilter", (String)DEFAULT_FILTER);
        String password = (String)parameters.get("password");
        String ldapDn = (String)parameters.get("dn");
        Object addressObject = iface.getAddress();
        String address = null;
        if (addressObject instanceof InetAddress) {
            address = InetAddressUtils.str((InetAddress)((InetAddress)addressObject));
        } else if (addressObject instanceof String) {
            address = (String)addressObject;
        }
        Double responseTime = null;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress((InetAddress)iface.getAddress(), ldapPort), tracker.getConnectionTimeout());
            socket.setSoTimeout(tracker.getSoTimeout());
            LOG.debug("LdapMonitor: connected to host: {} on port: {}", (Object)address, (Object)ldapPort);
            serviceStatus = 3;
            if (socket != null) {
                socket.close();
            }
            LDAPConnection lc = new LDAPConnection((LDAPSocketFactory)new TimeoutLDAPSocket(tracker.getSoTimeout()));
            tracker.reset();
            while (tracker.shouldRetry() && serviceStatus != 1) {
                block25: {
                    LOG.debug("polling LDAP on {}, {}", (Object)address, (Object)tracker);
                    tracker.startAttempt();
                    try {
                        lc.connect(address, ldapPort);
                        LOG.debug("connected to LDAP server {} on port {}", (Object)address, (Object)ldapPort);
                    }
                    catch (LDAPException e) {
                        LOG.debug("could not connect to LDAP server {} on port {}", (Object)address, (Object)ldapPort);
                        reason = "could not connect to LDAP server " + address + " on port " + ldapPort;
                        break block25;
                    }
                    if (ldapDn != null && password != null) {
                        try {
                            lc.bind(ldapVersion, ldapDn, password.getBytes());
                            LOG.debug("bound to LDAP server version {} with distinguished name {}", (Object)ldapVersion, (Object)ldapDn);
                            LOG.debug("poll: responseTime= {}ms", (Object)tracker.elapsedTimeInMillis());
                        }
                        catch (LDAPException e) {
                            try {
                                lc.disconnect();
                            }
                            catch (LDAPException ex) {
                                LOG.debug(ex.getMessage());
                            }
                            LOG.debug("could not bind to LDAP server version {} with distinguished name {}", (Object)ldapVersion, (Object)ldapDn);
                            reason = "could not bind to LDAP server version " + ldapVersion + " with distinguished name " + ldapDn;
                            break block25;
                        }
                    }
                    boolean attributeOnly = true;
                    String[] attrs = new String[]{"1.1"};
                    int searchScope = 1;
                    LOG.debug("running search {} from {}", (Object)searchFilter, (Object)searchBase);
                    LDAPSearchResults results = null;
                    int msLimit = (int)tracker.getTimeoutInMillis();
                    int serverLimit = (int)tracker.getTimeoutInSeconds() + 1;
                    LDAPSearchConstraints cons = new LDAPSearchConstraints(msLimit, serverLimit, 0, 1000, false, 1, null, 10);
                    try {
                        results = lc.search(searchBase, searchScope, searchFilter, attrs, attributeOnly, cons);
                        if (results != null && results.hasMore()) {
                            responseTime = tracker.elapsedTimeInMillis();
                            LOG.debug("search yielded {} result(s)", (Object)results.getCount());
                            serviceStatus = 1;
                        } else {
                            LOG.debug("no results found from search");
                            reason = "No results found from search";
                            serviceStatus = 2;
                        }
                    }
                    catch (LDAPException e) {
                        try {
                            lc.disconnect();
                        }
                        catch (LDAPException ex) {
                            LOG.debug(ex.getMessage());
                        }
                        LOG.debug("could not perform search {} from {}", (Object)searchFilter, (Object)searchBase);
                        reason = "could not perform search " + searchFilter + " from " + searchBase;
                        break block25;
                    }
                    try {
                        lc.disconnect();
                        LOG.debug("disconected from LDAP server {} on port {}", (Object)address, (Object)ldapPort);
                    }
                    catch (LDAPException e) {
                        LOG.debug(e.getMessage());
                    }
                }
                tracker.nextAttempt();
            }
        }
        catch (ConnectException e) {
            LOG.debug("connection refused to host {}", (Object)address, (Object)e);
            reason = "connection refused to host " + address;
        }
        catch (NoRouteToHostException e) {
            LOG.debug("No route to host {}", (Object)address, (Object)e);
            reason = "No route to host " + address;
        }
        catch (InterruptedIOException e) {
            LOG.debug("did not connect to host with {}", (Object)tracker);
            reason = "did not connect to host with " + tracker;
        }
        catch (Throwable t) {
            LOG.debug("An undeclared throwable exception caught contacting host {}", (Object)address, (Object)t);
            reason = "An undeclared throwable exception caught contacting host " + address;
        }
        return PollStatus.get((int)serviceStatus, (String)reason, responseTime);
    }

    private class TimeoutLDAPSocket
    extends TimeoutSocketFactory
    implements LDAPSocketFactory {
        public TimeoutLDAPSocket(int timeout) {
            super(timeout, LdapMonitor.this.getSocketWrapper());
        }
    }
}

