/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public abstract class JMXMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(JMXMonitor.class);

    public abstract ConnectionWrapper getMBeanServerConnection(Map<String, Object> var1, InetAddress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus serviceStatus = PollStatus.unavailable();
        String dsName = null;
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        ConnectionWrapper connection = null;
        try {
            int retry = ParameterMap.getKeyedInteger(map, (String)"retry", (int)3);
            long t0 = 0L;
            for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
                try {
                    t0 = System.nanoTime();
                    connection = this.getMBeanServerConnection(map, ipv4Addr);
                    if (connection == null) continue;
                    connection.getMBeanServer().getMBeanCount();
                    long nanoResponseTime = System.nanoTime() - t0;
                    serviceStatus = PollStatus.available((Double)((double)nanoResponseTime / 1000000.0));
                }
                catch (IOException e) {
                    String reason = dsName + ": IOException while polling address: " + ipv4Addr;
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                break;
            }
        }
        catch (Throwable e) {
            String reason = dsName + " Monitor - failed! " + InetAddressUtils.str((InetAddress)ipv4Addr);
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable((String)reason);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return serviceStatus;
    }
}

