/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.monitors.JDBCMonitor;

public final class JDBCStoredProcedureMonitor
extends JDBCMonitor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus checkDatabaseStatus(Connection con, Map<String, Object> parameters) {
        PollStatus status = PollStatus.unavailable();
        CallableStatement cs = null;
        try {
            boolean bPass = false;
            String storedProcedure = ParameterMap.getKeyedString(parameters, (String)"stored-procedure", null);
            if (storedProcedure == null) {
                PollStatus pollStatus = status;
                return pollStatus;
            }
            String schemaName = ParameterMap.getKeyedString(parameters, (String)"schema", (String)"test");
            String procedureCall = "{ ? = call " + schemaName + "." + storedProcedure + "()}";
            cs = con.prepareCall(procedureCall);
            LOG.debug("Calling stored procedure: {}", (Object)procedureCall);
            cs.registerOutParameter(1, -7);
            cs.executeUpdate();
            bPass = cs.getBoolean(1);
            LOG.debug("Stored procedure returned: {}", (Object)bPass);
            if (bPass) {
                status = PollStatus.available();
            }
            this.closeStmt(cs);
        }
        catch (SQLException sqlEx) {
            String reason = "JDBC stored procedure call not functional: " + sqlEx.getSQLState() + ", " + sqlEx.toString();
            LOG.debug(reason, (Throwable)sqlEx);
            status = PollStatus.unavailable((String)reason);
        }
        finally {
            this.closeStmt(cs);
        }
        return status;
    }
}

