/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class ImapMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ImapMonitor.class);
    private static final int DEFAULT_PORT = 143;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static String IMAP_START_RESPONSE_PREFIX = "* OK ";
    private static String IMAP_LOGOUT_REQUEST = "ONMSPOLLER LOGOUT\r\n";
    private static String IMAP_BYE_RESPONSE_PREFIX = "* BYE ";
    private static String IMAP_LOGOUT_RESPONSE_PREFIX = "ONMSPOLLER OK ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)143);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        LOG.debug("ImapMonitor.poll: address: {} port: {} {}", new Object[]{ipv4Addr, port, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                serviceStatus = PollStatus.unresponsive();
                BufferedReader rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = rdr.readLine();
                double responseTime = tracker.elapsedTimeInMillis();
                LOG.debug("ImapMonitor.Poll(): banner: {}", (Object)banner);
                if (banner != null && banner.startsWith(IMAP_START_RESPONSE_PREFIX)) {
                    socket.getOutputStream().write(IMAP_LOGOUT_REQUEST.getBytes());
                    String response = rdr.readLine();
                    if (response != null && response.startsWith(IMAP_BYE_RESPONSE_PREFIX) && (response = rdr.readLine()) != null && response.startsWith(IMAP_LOGOUT_RESPONSE_PREFIX)) {
                        serviceStatus = PollStatus.available((Double)responseTime);
                    }
                }
                if (!serviceStatus.isAvailable()) {
                    serviceStatus = PollStatus.unavailable();
                }
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address: " + ipv4Addr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipv4Addr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host with " + tracker;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipv4Addr;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    LOG.debug("ImapMonitor.poll: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

