/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.SnmpMonitor;

public class Win32ServiceMonitor
extends SnmpMonitor {
    private static final String SV_SVC_OPERATING_STATE_OID = ".1.3.6.1.4.1.77.1.2.3.1.3";
    private static final String DEFAULT_SERVICE_NAME = "Server";

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"service-name", (String)DEFAULT_SERVICE_NAME);
        int snLength = serviceName.length();
        StringBuffer serviceOidBuf = new StringBuffer(SV_SVC_OPERATING_STATE_OID);
        serviceOidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : serviceName.getBytes()) {
            serviceOidBuf.append(".").append(Byte.toString(thisByte));
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("For Win32 service '" + serviceName + "', OID to check is " + serviceOidBuf.toString());
        }
        parameters.put("oid", serviceOidBuf.toString());
        parameters.put("operator", "=");
        parameters.put("operand", "1");
        return super.poll(svc, parameters);
    }
}

