/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;

@Distributable
public class WebMonitor
extends AbstractServiceMonitor {
    static Integer DEFAULT_TIMEOUT = 3000;
    static Integer DEFAULT_PORT = 80;
    static String DEFAULT_USER_AGENT = "OpenNMS WebMonitor";
    static String DEFAULT_PATH = "/";
    static String DEFAULT_USER = "admin";
    static String DEFAULT_PASSWORD = "admin";
    static String DEFAULT_HTTP_STATUS_RANGE = "100-399";
    static String DEFAULT_SCHEME = "http";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        PollStatus pollStatus = PollStatus.unresponsive();
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            String hostAddress = InetAddressUtils.str((InetAddress)svc.getAddress());
            URIBuilder ub = new URIBuilder();
            ub.setScheme(ParameterMap.getKeyedString(map, (String)"scheme", (String)DEFAULT_SCHEME));
            ub.setHost(hostAddress);
            ub.setPort(ParameterMap.getKeyedInteger(map, (String)"port", (int)DEFAULT_PORT));
            ub.setPath(ParameterMap.getKeyedString(map, (String)"path", (String)DEFAULT_PATH));
            HttpGet getMethod = new HttpGet(ub.build());
            httpClient.getParams().setIntParameter("http.connection.timeout", ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT));
            httpClient.getParams().setIntParameter("http.socket.timeout", ParameterMap.getKeyedInteger(map, (String)"timeout", (int)DEFAULT_TIMEOUT));
            httpClient.getParams().setParameter("http.useragent", (Object)ParameterMap.getKeyedString(map, (String)"user-agent", (String)DEFAULT_USER_AGENT));
            getMethod.getParams().setParameter("http.virtual-host", (Object)new HttpHost(ParameterMap.getKeyedString(map, (String)"virtual-host", (String)hostAddress), ParameterMap.getKeyedInteger(map, (String)"port", (int)DEFAULT_PORT)));
            if (ParameterMap.getKeyedBoolean(map, (String)"http-1.0", (boolean)false)) {
                httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
            }
            for (String okey : map.keySet()) {
                String key = okey.toString();
                if (!key.matches("header_[0-9]+$")) continue;
                String headerName = ParameterMap.getKeyedString(map, (String)key, null);
                String headerValue = ParameterMap.getKeyedString(map, (String)(key + "_value"), null);
                getMethod.setHeader(headerName, headerValue);
            }
            if (ParameterMap.getKeyedBoolean(map, (String)"auth-enabled", (boolean)false)) {
                httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ParameterMap.getKeyedString(map, (String)"auth-user", (String)DEFAULT_USER), ParameterMap.getKeyedString(map, (String)"auth-password", (String)DEFAULT_PASSWORD)));
                if (ParameterMap.getKeyedBoolean(map, (String)"auth-preemptive", (boolean)true)) {
                    HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor(){

                        public void process(HttpRequest request, HttpContext context) throws IOException {
                            AuthScope authScope;
                            Credentials creds;
                            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                            if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                                authState.update((AuthScheme)new BasicScheme(), creds);
                            }
                        }
                    };
                    httpClient.addRequestInterceptor(preemptiveAuth, 0);
                }
            }
            this.log().debug("httpClient request with the following parameters: " + httpClient);
            this.log().debug("getMethod parameters: " + getMethod);
            HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            String statusText = response.getStatusLine().getReasonPhrase();
            String expectedText = ParameterMap.getKeyedString(map, (String)"response-text", null);
            this.log().debug("returned results are:");
            pollStatus = !this.inRange(ParameterMap.getKeyedString(map, (String)"response-range", (String)DEFAULT_HTTP_STATUS_RANGE), statusCode) ? PollStatus.unavailable((String)statusText) : PollStatus.available();
            if (expectedText != null) {
                String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                pollStatus = expectedText.charAt(0) == '~' ? (!responseText.matches(expectedText.substring(1)) ? PollStatus.unavailable((String)"Regex Failed") : PollStatus.available()) : (expectedText.equals(responseText) ? PollStatus.available() : PollStatus.unavailable((String)"Did not find expected Text"));
            }
        }
        catch (IOException e) {
            this.log().info(e.getMessage());
        }
        catch (URISyntaxException e) {
            this.log().info(e.getMessage());
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
        return pollStatus;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= new Integer(boundries[0]) && val <= new Integer(boundries[1]);
    }
}

