/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.protocols.InsufficientParametersException;
import org.opennms.netmgt.protocols.ssh.Ssh;

@Distributable
public final class SshMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 22;

    public PollStatus poll(InetAddress address, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)22);
        String banner = ParameterMap.getKeyedString(parameters, (String)"banner", null);
        String match = ParameterMap.getKeyedString(parameters, (String)"match", null);
        String clientBanner = ParameterMap.getKeyedString(parameters, (String)"client-banner", (String)"SSH-1.99-OpenNMS_1.5");
        PollStatus ps = PollStatus.unavailable();
        Ssh ssh = new Ssh(address, port, tracker.getConnectionTimeout());
        ssh.setClientBanner(clientBanner);
        RE regex = null;
        try {
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = new RE(match);
            } else if (banner != null) {
                regex = new RE(banner);
            }
        }
        catch (RESyntaxException e) {
            String matchString = match == null ? banner : match;
            LogUtils.infof((Object)this, (String)"Invalid regular expression for SSH banner match /%s/: %s", (Object[])new Object[]{matchString, e.getMessage()});
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Invalid Regular expression for SSH banner match /%s/", (Object[])new Object[]{matchString});
        }
        tracker.reset();
        while (tracker.shouldRetry() && !ps.isAvailable()) {
            try {
                ps = ssh.poll(tracker);
            }
            catch (InsufficientParametersException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"An error occurred polling host '%s'", (Object[])new Object[]{address});
                break;
            }
            if (ps.isAvailable()) {
                if (regex == null) {
                    return ps;
                }
                String response = ssh.getServerBanner();
                if (response == null) {
                    return PollStatus.unavailable((String)"server closed connection before banner was received.");
                }
                if (regex.match(response)) {
                    LogUtils.debugf((Object)this, (String)"isServer: matching response=%s", (Object[])new Object[]{response});
                    return ps;
                }
                LogUtils.debugf((Object)this, (String)"isServer: NON-matching response=%s", (Object[])new Object[]{response});
                return PollStatus.unavailable((String)("server responded, but banner did not match '" + banner + "'"));
            }
            tracker.nextAttempt();
        }
        return ps;
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        InetAddress address = (InetAddress)iface.getAddress();
        return this.poll(address, parameters);
    }
}

