/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.SocketWrapper;
import org.opennms.core.utils.SslSocketWrapper;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;

@Distributable
public final class SSLCertMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_DAYS = 7;
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_DAYS = "days";
    private static Calendar m_calendar;

    SSLCertMonitor() {
        m_calendar = null;
    }

    SSLCertMonitor(Calendar cal) {
        m_calendar = cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_PORT, (int)-1);
        if (port == -1) {
            throw new RuntimeException("Required parameter 'port' is not present in supplied properties.");
        }
        int validityDays = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_DAYS, (int)7);
        if (validityDays <= 0) {
            throw new RuntimeException("Required parameter 'days' must be a positive value.");
        }
        Calendar calValid = GregorianCalendar.getInstance();
        Calendar calCurrent = GregorianCalendar.getInstance();
        if (m_calendar != null) {
            calCurrent.setTimeInMillis(m_calendar.getTimeInMillis());
        }
        calValid.setTimeInMillis(calCurrent.getTimeInMillis());
        calValid.add(5, validityDays);
        Calendar calBefore = GregorianCalendar.getInstance();
        Calendar calAfter = GregorianCalendar.getInstance();
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        this.log().debug("poll: address=" + hostAddress + ", port=" + port + ", " + tracker);
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                this.log().debug("Connected to host: " + ipv4Addr + " on port: " + port);
                SSLSocket sslSocket = (SSLSocket)this.getSocketWrapper().wrapSocket(socket);
                serviceStatus = PollStatus.unresponsive();
                Certificate[] certs = sslSocket.getSession().getPeerCertificates();
                for (int i = 0; i < certs.length && !serviceStatus.isAvailable(); ++i) {
                    if (!(certs[i] instanceof X509Certificate)) continue;
                    X509Certificate certx = (X509Certificate)certs[i];
                    this.log().debug("Checking validity against dates: [current: " + calCurrent.getTime() + ", valid: " + calValid.getTime() + "], NotBefore: " + certx.getNotBefore() + ", NotAfter: " + certx.getNotAfter());
                    calBefore.setTime(certx.getNotBefore());
                    calAfter.setTime(certx.getNotAfter());
                    serviceStatus = calCurrent.before(calBefore) ? this.logDown(Level.WARN, "Certificate is invalid, current time is before start time") : (calCurrent.before(calAfter) ? (calValid.before(calAfter) ? this.logUp(Level.DEBUG, tracker.elapsedTimeInMillis(), "Certificate is valid, and does not expire before validity check date") : this.logDown(Level.ERROR, "Certificate is valid, but will expire in " + validityDays + " days.")) : this.logDown(Level.ERROR, "Certificate has expired."));
                    break;
                }
            }
            catch (NoRouteToHostException e) {
                serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + hostAddress, e);
                break;
            }
            catch (InterruptedIOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
            }
            catch (ConnectException e) {
                serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
            }
            catch (IOException e) {
                serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    this.log().debug("poll: Error closing socket." + e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    protected SocketWrapper getSocketWrapper() {
        return new SslSocketWrapper();
    }

    public void setCalendar(Calendar cal) {
        m_calendar = cal;
    }

    public Calendar getCalendar() {
        return m_calendar;
    }
}

