/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.lang.reflect.Field;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class DefaultElementLocator
implements ElementLocator {
    private final WebDriver driver;
    private final boolean cacheElement;
    private final By by;
    private WebElement cachedElement;

    public DefaultElementLocator(WebDriver driver, Field field) {
        this.driver = driver;
        Annotations annotations = new Annotations(field);
        this.cacheElement = annotations.isLookupCached();
        this.by = annotations.buildBy();
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.cacheElement) {
            return this.cachedElement;
        }
        WebElement element = this.driver.findElement(this.by);
        if (this.cacheElement) {
            this.cachedElement = element;
        }
        return element;
    }
}

