/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class SeleneseTestBase {
    private static final boolean THIS_IS_WINDOWS = File.pathSeparator.equals(";");
    private boolean captureScreenShotOnFailure = false;
    protected Selenium selenium;
    protected StringBuffer verificationErrors = new StringBuffer();

    public void setUp() throws Exception {
        this.setUp(null);
    }

    public void setUp(String url) throws Exception {
        this.setUp(url, this.runtimeBrowserString());
    }

    protected String runtimeBrowserString() {
        String defaultBrowser = System.getProperty("selenium.defaultBrowser");
        if (null != defaultBrowser && defaultBrowser.startsWith("${")) {
            defaultBrowser = null;
        }
        if (defaultBrowser == null) {
            defaultBrowser = THIS_IS_WINDOWS ? "*iexplore" : "*firefox";
        }
        return defaultBrowser;
    }

    public void setUp(String url, String browserString) throws Exception {
        this.setUp(url, browserString, this.getDefaultPort());
    }

    protected int getDefaultPort() {
        try {
            Class<?> c = Class.forName("org.openqa.selenium.server.RemoteControlConfiguration");
            Method getDefaultPort = c.getMethod("getDefaultPort", new Class[0]);
            Integer portNumber = (Integer)getDefaultPort.invoke(null, new Object[0]);
            return portNumber;
        }
        catch (Exception e) {
            return Integer.getInteger("selenium.port", 4444);
        }
    }

    public void setUp(String url, String browserString, int port) throws Exception {
        if (url == null) {
            url = "http://localhost:" + port;
        }
        this.selenium = new DefaultSelenium("localhost", port, browserString, url);
        this.selenium.start();
    }

    public void verifyTrue(boolean b) {
        try {
            SeleneseTestBase.assertTrue(b);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public void verifyFalse(boolean b) {
        try {
            SeleneseTestBase.assertFalse(b);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public String getText() {
        return this.selenium.getEval("this.page().bodyText()");
    }

    public void verifyEquals(Object s1, Object s2) {
        try {
            SeleneseTestBase.assertEquals(s1, s2);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public void verifyEquals(boolean s1, boolean s2) {
        try {
            SeleneseTestBase.assertEquals(s1, s2);
        }
        catch (Error e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString(e));
        }
    }

    public static void assertEquals(Object s1, Object s2) {
        if (s1 instanceof String && s2 instanceof String) {
            SeleneseTestBase.assertEquals((String)s1, (String)s2);
        } else if (s1 instanceof String && s2 instanceof String[]) {
            SeleneseTestBase.assertEquals((String)s1, (String[])s2);
        } else if (s1 instanceof String && s2 instanceof Number) {
            SeleneseTestBase.assertEquals((String)s1, s2.toString());
        } else if (s1 instanceof Number && s2 instanceof String) {
            SeleneseTestBase.assertEquals(s1.toString(), (String)s2);
        } else if (s1 instanceof String[] && s2 instanceof String[]) {
            String[] sa1 = (String[])s1;
            String[] sa2 = (String[])s2;
            if (sa1.length != sa2.length) {
                throw new Error("Expected " + sa1 + " but saw " + sa2);
            }
            for (int j = 0; j < sa1.length; ++j) {
                SeleneseTestBase.assertEquals(sa1[j], sa2[j]);
            }
        } else if (s1 == null) {
            SeleneseTestBase.assertTrue(s2 == null);
        } else {
            SeleneseTestBase.assertTrue(s1.equals(s2));
        }
    }

    public static void assertEquals(String s1, String s2) {
        SeleneseTestBase.assertTrue("Expected \"" + s1 + "\" but saw \"" + s2 + "\" instead", SeleneseTestBase.seleniumEquals(s1, s2));
    }

    public static void assertEquals(String s1, String[] s2) {
        SeleneseTestBase.assertEquals(s1, SeleneseTestBase.join(s2, ','));
    }

    public static boolean seleniumEquals(String expectedPattern, String actual) {
        Boolean b;
        if (actual.startsWith("regexp:") || actual.startsWith("regex:") || actual.startsWith("regexpi:") || actual.startsWith("regexi:")) {
            String tmp = actual;
            actual = expectedPattern;
            expectedPattern = tmp;
        }
        if ((b = SeleneseTestBase.handleRegex("regexp:", expectedPattern, actual, 0)) != null) {
            return b;
        }
        b = SeleneseTestBase.handleRegex("regex:", expectedPattern, actual, 0);
        if (b != null) {
            return b;
        }
        b = SeleneseTestBase.handleRegex("regexpi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        b = SeleneseTestBase.handleRegex("regexi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        if (expectedPattern.startsWith("exact:")) {
            String expectedExact = expectedPattern.replaceFirst("exact:", "");
            if (!expectedExact.equals(actual)) {
                System.out.println("expected " + actual + " to match " + expectedPattern);
                return false;
            }
            return true;
        }
        String expectedGlob = expectedPattern.replaceFirst("glob:", "");
        expectedGlob = expectedGlob.replaceAll("([\\]\\[\\\\{\\}$\\(\\)\\|\\^\\+.])", "\\\\$1");
        expectedGlob = expectedGlob.replaceAll("\\*", ".*");
        if (!Pattern.compile(expectedGlob = expectedGlob.replaceAll("\\?", "."), 32).matcher(actual).matches()) {
            System.out.println("expected \"" + actual + "\" to match glob \"" + expectedPattern + "\" (had transformed the glob into regexp \"" + expectedGlob + "\"");
            return false;
        }
        return true;
    }

    private static Boolean handleRegex(String prefix, String expectedPattern, String actual, int flags) {
        if (expectedPattern.startsWith(prefix)) {
            String expectedRegEx = expectedPattern.replaceFirst(prefix, ".*") + ".*";
            Pattern p = Pattern.compile(expectedRegEx, flags);
            if (!p.matcher(actual).matches()) {
                System.out.println("expected " + actual + " to match regexp " + expectedPattern);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public static boolean seleniumEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            return SeleneseTestBase.seleniumEquals((String)expected, (String)actual);
        }
        return expected.equals(actual);
    }

    public static void assertEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = SeleneseTestBase.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            throw new AssertionError((Object)comparisonDumpIfNotEqual);
        }
    }

    public void verifyEquals(String[] s1, String[] s2) {
        String comparisonDumpIfNotEqual = SeleneseTestBase.verifyEqualsAndReturnComparisonDumpIfNot(s1, s2);
        if (comparisonDumpIfNotEqual != null) {
            this.verificationErrors.append(comparisonDumpIfNotEqual);
        }
    }

    private static String verifyEqualsAndReturnComparisonDumpIfNot(String[] s1, String[] s2) {
        boolean misMatch = false;
        if (s1.length != s2.length) {
            misMatch = true;
        }
        for (int j = 0; j < s1.length; ++j) {
            if (SeleneseTestBase.seleniumEquals(s1[j], s2[j])) continue;
            misMatch = true;
            break;
        }
        if (misMatch) {
            return "Expected " + SeleneseTestBase.stringArrayToString(s1) + " but saw " + SeleneseTestBase.stringArrayToString(s2);
        }
        return null;
    }

    private static String stringArrayToString(String[] sa) {
        StringBuffer sb = new StringBuffer("{");
        for (int j = 0; j < sa.length; ++j) {
            sb.append(" ").append("\"").append(sa[j]).append("\"");
        }
        sb.append(" }");
        return sb.toString();
    }

    private static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String join(String[] sa, char c) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < sa.length; ++j) {
            sb.append(sa[j]);
            if (j >= sa.length - 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void verifyNotEquals(Object s1, Object s2) {
        try {
            SeleneseTestBase.assertNotEquals(s1, s2);
        }
        catch (AssertionError e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString((Throwable)((Object)e)));
        }
    }

    public void verifyNotEquals(boolean s1, boolean s2) {
        try {
            SeleneseTestBase.assertNotEquals((Object)s1, (Object)s2);
        }
        catch (AssertionError e) {
            this.verificationErrors.append(SeleneseTestBase.throwableToString((Throwable)((Object)e)));
        }
    }

    public static void assertNotEquals(Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            SeleneseTestBase.fail("did not expect values to be equal (" + obj1.toString() + ")");
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            SeleneseTestBase.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        SeleneseTestBase.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        SeleneseTestBase.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        SeleneseTestBase.assertTrue(null, !condition);
    }

    public static void assertNotEquals(boolean b1, boolean b2) {
        SeleneseTestBase.assertNotEquals((Object)b1, (Object)b2);
    }

    public void pause(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkForVerificationErrors() {
        String verificationErrorString = this.verificationErrors.toString();
        this.clearVerificationErrors();
        if (!"".equals(verificationErrorString)) {
            SeleneseTestBase.fail(verificationErrorString);
        }
    }

    public void clearVerificationErrors() {
        this.verificationErrors = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.checkForVerificationErrors();
        }
        finally {
            if (this.selenium != null) {
                this.selenium.stop();
                this.selenium = null;
            }
        }
    }

    protected boolean isCaptureScreenShotOnFailure() {
        return this.captureScreenShotOnFailure;
    }

    protected void setCaptureScreenShotOnFailure(boolean captureScreetShotOnFailure) {
        this.captureScreenShotOnFailure = captureScreetShotOnFailure;
    }
}

