/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.krupczak.xmp.SocketOpts;
import org.krupczak.xmp.Xmp;
import org.krupczak.xmp.XmpMessage;
import org.krupczak.xmp.XmpSession;
import org.krupczak.xmp.XmpVar;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.collector.AttributeGroup;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;
import org.opennms.netmgt.config.xmpDataCollection.Group;
import org.opennms.netmgt.config.xmpDataCollection.MibObj;
import org.opennms.netmgt.config.xmpDataCollection.XmpCollection;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionAttribute;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionAttributeType;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionFactory;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionResource;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionSet;
import org.opennms.netmgt.protocols.xmp.config.XmpAgentConfig;
import org.opennms.netmgt.protocols.xmp.config.XmpConfigFactory;
import org.opennms.netmgt.protocols.xmp.config.XmpPeerFactory;

public class XmpCollector
implements ServiceCollector {
    static final String SERVICE_NAME = "XMP";
    int xmpPort;
    int timeout;
    int retries;
    Set<CollectionAgent> setOfNodes;
    SocketOpts sockopts;
    String authenUser;

    public XmpCollector() {
        this.log().debug("XmpCollector created");
        this.setOfNodes = new HashSet<CollectionAgent>();
        this.xmpPort = 5270;
        this.sockopts = new SocketOpts();
        this.authenUser = new String("xmpUser");
        this.timeout = 3000;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private boolean handleScalarQuery(String groupName, XmpCollectionSet collectionSet, long oldUptime, XmpSession session, XmpCollectionResource scalarResource, XmpVar[] queryVars) {
        XmpMessage reply = session.queryVars(queryVars);
        if (reply == null) {
            this.log().warn("collect: query to " + collectionSet.getCollectionAgent() + " failed, " + Xmp.errorStatusToString((int)session.getErrorStatus()));
            return false;
        }
        AttributeGroupType agt = new AttributeGroupType(groupName, "ignore");
        AttributeGroup ag = new AttributeGroup((CollectionResource)scalarResource, agt);
        XmpVar[] vars = reply.getMIBVars();
        long newUptime = 0L;
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i].getMibName().equals("core") && vars[i].getObjName().equals("sysUpTime")) {
                newUptime = vars[i].getValueLong();
            }
            XmpCollectionAttributeType attribType = new XmpCollectionAttributeType(vars[i], agt);
            XmpCollectionAttribute aVar = new XmpCollectionAttribute(scalarResource, attribType, vars[i].getObjName(), vars[i]);
            ag.addAttribute((CollectionAttribute)aVar);
        }
        if (newUptime > oldUptime) {
            collectionSet.ignorePersistFalse();
        }
        if (newUptime > 0L) {
            collectionSet.getCollectionAgent().setSavedSysUpTime(newUptime);
        }
        scalarResource.addAttributeGroup(ag);
        return true;
    }

    private boolean handleTableQuery(String groupName, String resourceType, XmpCollectionSet collectionSet, String[] tableInfo, XmpSession session, XmpVar[] queryVars) {
        int numColumns = queryVars.length;
        String targetInstance = tableInfo[2];
        if (tableInfo[2] == null || tableInfo[2].length() == 0) {
            tableInfo[2] = new String("*");
            targetInstance = null;
        }
        this.log().debug("sending table query " + tableInfo[0] + "," + tableInfo[1] + "," + tableInfo[2] + " target: " + targetInstance);
        XmpMessage reply = session.queryTableVars(tableInfo, 0, queryVars);
        if (reply == null) {
            this.log().warn("collect: query to " + collectionSet.getCollectionAgent() + " failed, " + Xmp.errorStatusToString((int)session.getErrorStatus()));
            return false;
        }
        XmpVar[] vars = reply.getMIBVars();
        int numRows = vars.length / numColumns;
        this.log().info("query returned valid table data for " + groupName + " numRows=" + numRows + " numColumns=" + numColumns);
        for (int i = 0; i < numRows; ++i) {
            String rowInstance = vars[i * numColumns].getKey();
            XmpCollectionResource rowResource = targetInstance != null ? new XmpCollectionResource(collectionSet.getCollectionAgent(), resourceType, tableInfo[1], targetInstance) : new XmpCollectionResource(collectionSet.getCollectionAgent(), resourceType, tableInfo[1], rowInstance);
            AttributeGroupType agt = new AttributeGroupType(groupName, "all");
            AttributeGroup ag = new AttributeGroup((CollectionResource)rowResource, agt);
            this.log().debug("queryTable instance=" + rowInstance);
            for (int j = 0; j < numColumns; ++j) {
                XmpCollectionAttributeType attribType = new XmpCollectionAttributeType(vars[i * numColumns + j], agt);
                XmpCollectionAttribute aVar = new XmpCollectionAttribute(rowResource, attribType, vars[i * numColumns + j].getObjName(), vars[i * numColumns + j]);
                ag.addAttribute((CollectionAttribute)aVar);
            }
            rowResource.addAttributeGroup(ag);
            collectionSet.addResource(rowResource);
            this.log().info("query table data adding row resource " + (Object)((Object)rowResource));
        }
        return true;
    }

    public void initialize(Map<String, String> parameters) {
        this.log().debug("initialize(params) called");
        try {
            XmpCollectionFactory.init();
        }
        catch (Throwable e) {
            this.log().error("initialize: XmpCollectionFactory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        try {
            XmpPeerFactory.init();
        }
        catch (Throwable e) {
            this.log().error("initialize: XmpPeerFactory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        try {
            XmpConfigFactory.init();
        }
        catch (Throwable e) {
            this.log().error("initialize: config factory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        File f = new File(XmpCollectionFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + XmpCollectionFactory.getInstance().getRrdPath());
        }
        XmpConfig protoConfig = XmpConfigFactory.getInstance().getXmpConfig();
        if (protoConfig.hasPort()) {
            this.xmpPort = protoConfig.getPort();
        }
        if (protoConfig.hasTimeout()) {
            this.timeout = protoConfig.getTimeout();
        }
        if (protoConfig.getAuthenUser() != null) {
            this.authenUser = protoConfig.getAuthenUser();
        }
        this.log().debug("initialize: authenUser '" + this.authenUser + "' port " + this.xmpPort);
        this.log().debug("initialize: keystore found? " + this.sockopts.getKeystoreFound());
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        this.log().debug("initialize agent/params called for " + agent);
        this.setOfNodes.add(agent);
    }

    public void release() {
        this.log().info("release()");
        this.setOfNodes = new HashSet<CollectionAgent>();
    }

    public void release(CollectionAgent agent) {
        this.log().info("release agent called for " + agent);
        this.setOfNodes.remove(agent);
    }

    public String serviceName() {
        return SERVICE_NAME;
    }

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) {
        String collectionName;
        this.log().debug("collect agent " + agent);
        long oldUptime = 0L;
        XmpAgentConfig peerConfig = XmpPeerFactory.getInstance().getAgentConfig(agent.getInetAddress());
        this.authenUser = peerConfig.getAuthenUser();
        this.timeout = (int)peerConfig.getTimeout();
        this.retries = peerConfig.getRetry();
        this.xmpPort = peerConfig.getPort();
        if (parameters.get("authenUser") != null) {
            this.authenUser = ParameterMap.getKeyedString(parameters, (String)"authenUser", null);
        }
        if (parameters.get("timeout") != null) {
            this.timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        }
        if (parameters.get("retry") != null) {
            this.retries = ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)0);
        }
        parameters.get("collection");
        if (parameters.get("port") != null) {
            this.xmpPort = Integer.valueOf((String)parameters.get("port"));
        }
        if ((collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null)) == null) {
            this.log().warn("collect found no collectionName for " + agent);
            return null;
        }
        this.log().debug("XmpCollector: collect " + collectionName + " from " + agent);
        XmpCollectionSet collectionSet = new XmpCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatusFailed();
        collectionSet.ignorePersistTrue();
        XmpCollectionResource scalarResource = new XmpCollectionResource(agent, null, "node", null);
        collectionSet.addResource(scalarResource);
        XmpCollection collection = XmpCollectionFactory.getInstance().getXmpCollection(collectionName);
        if (collection == null) {
            this.log().warn("collect found no matching collection for " + agent);
            return collectionSet;
        }
        oldUptime = agent.getSavedSysUpTime();
        this.log().debug("collect: attempting to open XMP session with " + agent.getInetAddress() + ":" + this.xmpPort + "," + this.authenUser);
        this.sockopts.setConnectTimeout(this.timeout);
        XmpSession session = new XmpSession(this.sockopts, agent.getInetAddress(), this.xmpPort, this.authenUser);
        if (session.isClosed()) {
            this.log().warn("collect unable to open XMP session with " + agent);
            return collectionSet;
        }
        this.log().debug("collect: successfully opened XMP session with" + agent);
        for (Group group : collection.getGroups().getGroup()) {
            String groupName = group.getName();
            MibObj[] mibObjects = group.getMibObj();
            XmpVar[] vars = new XmpVar[mibObjects.length];
            this.log().debug("collecting XMP group " + groupName + " with " + mibObjects.length + " mib objects");
            for (int i = 0; i < mibObjects.length; ++i) {
                vars[i] = new XmpVar(mibObjects[i].getMib(), mibObjects[i].getVar(), mibObjects[i].getInstance(), "", 13);
            }
            if (mibObjects[0].getTable() != null && mibObjects[0].getTable().length() != 0) {
                String[] tableInfo = new String[]{mibObjects[0].getMib(), mibObjects[0].getTable(), mibObjects[0].getInstance()};
                if (this.handleTableQuery(group.getName(), group.getResourceType(), collectionSet, tableInfo, session, vars)) continue;
                session.closeSession();
                return collectionSet;
            }
            if (this.handleScalarQuery(group.getName(), collectionSet, oldUptime, session, scalarResource, vars)) continue;
            session.closeSession();
            return collectionSet;
        }
        session.closeSession();
        collectionSet.setStatus(1);
        this.log().debug("XMP collect finished for " + collectionName + ", uptime for " + agent + " is " + agent.getSavedSysUpTime());
        return collectionSet;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        this.log().debug("XMP getRrdRepository called for " + collectionName);
        return XmpCollectionFactory.getInstance().getRrdRepository(collectionName);
    }
}

