/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import org.krupczak.xmp.Xmp;
import org.krupczak.xmp.XmpVar;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionAttributeType;
import org.opennms.netmgt.config.collector.Persister;

class XmpCollectionAttributeType
implements CollectionAttributeType {
    XmpVar aVar;
    AttributeGroupType groupType;

    XmpCollectionAttributeType(XmpVar aVar, AttributeGroupType groupType) {
        this.aVar = aVar;
        this.groupType = groupType;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public AttributeGroupType getGroupType() {
        return this.groupType;
    }

    public void storeAttribute(CollectionAttribute attrib, Persister persister) {
        this.log().debug("XmpCollectionAttributeType: store " + attrib);
        switch (this.aVar.getSyntax()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                persister.persistNumericAttribute(attrib);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                persister.persistStringAttribute(attrib);
                break;
            }
            default: {
                persister.persistStringAttribute(attrib);
            }
        }
    }

    public String getName() {
        return this.aVar.getObjName();
    }

    public String getType() {
        return Xmp.syntaxToString((int)this.aVar.getSyntax());
    }

    public String toString() {
        return "XmpCollectionAttributeType " + Xmp.syntaxToString((int)this.aVar.getSyntax());
    }
}

