/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp;

import java.math.BigInteger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.krupczak.xmp.Xmp;
import org.krupczak.xmp.XmpMessage;
import org.krupczak.xmp.XmpSession;
import org.krupczak.xmp.XmpVar;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.protocols.xmp.XmpUtilException;

public class XmpUtil {
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN_EQUALS = "<=";
    public static final String GREATER_THAN_EQUALS = ">=";
    public static final String EQUALS = "=";
    public static final String NOT_EQUAL = "!=";
    public static final String MATCHES = "~";

    private static boolean valueMeetsCriteria(XmpVar replyVar, String valueOperator, String valueOperand, ThreadCategory log, boolean caseSensitive) throws XmpUtilException {
        RE valueRegex = null;
        if (MATCHES.equals(valueOperator)) {
            try {
                valueRegex = new RE(valueOperand);
                if (!caseSensitive) {
                    valueRegex.setMatchFlags(1);
                }
            }
            catch (RESyntaxException e) {
                LogUtils.debugf(XmpUtil.class, (Throwable)e, (String)"Unable to initialize regular expression.", (Object[])new Object[0]);
            }
        }
        if (valueRegex != null && valueRegex.match(replyVar.getValue())) {
            if (log.isDebugEnabled()) {
                log.debug("handleScalarQuery: Response value |" + replyVar.getValue() + "| matches, returning true");
            }
            return true;
        }
        if (MATCHES.equals(valueOperator) && (valueRegex == null || "".equals(valueRegex))) {
            if (log.isDebugEnabled()) {
                log.debug("handleScalarQuery: Doing regex match but regex is null or empty, considering value |" + replyVar.getValue() + "| a match!");
            }
            return true;
        }
        if (!MATCHES.equals(valueOperator)) {
            if (valueOperand == null) {
                if (log.isDebugEnabled()) {
                    log.debug("valueMeetsCriteria: operand is null, so any non-error reply will match");
                }
                if (replyVar.getValue() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("valueMeetsCriteria: non-null reply value |" + replyVar.getValue() + "| considered a match");
                    }
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("valueMeetsCriteria: null reply NOT considered a match");
                }
                return false;
            }
            if (valueOperand.matches("^-?[0-9]+$")) {
                BigInteger intOperand;
                BigInteger intValue;
                if (log.isDebugEnabled()) {
                    log.debug("valueMeetsCriteria: operand " + valueOperand + " looks like an integer, treating with BigInteger");
                }
                try {
                    intValue = new BigInteger(replyVar.getValue());
                    intOperand = new BigInteger(valueOperand);
                }
                catch (NumberFormatException nfe) {
                    log.error("Failed to parse operand " + valueOperand + " or observed value " + replyVar.getValue() + " as a BigInteger, giving up");
                    log.info(nfe.getMessage());
                    throw new XmpUtilException("Operand '" + valueOperand + "' or observed value '" + replyVar.getValue() + "' is a malformed integer");
                }
                if (LESS_THAN.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) < 0;
                }
                if (GREATER_THAN.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) > 0;
                }
                if (LESS_THAN_EQUALS.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) <= 0;
                }
                if (GREATER_THAN_EQUALS.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) >= 0;
                }
                if (EQUALS.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) == 0;
                }
                if (NOT_EQUAL.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) != 0;
                }
                log.error("Unknown value operator '" + valueOperator + "', giving up");
                throw new XmpUtilException("Operator '" + valueOperator + "' unknown");
            }
            if (valueOperand.matches("^-?[0-9]+([,.]?[0-9]+)$")) {
                float floatOperand;
                float floatValue;
                if (log.isDebugEnabled()) {
                    log.debug("valueMeetsCriteria: operand " + valueOperand + " looks like a float, treating with float");
                }
                try {
                    floatValue = Float.parseFloat(valueOperand);
                    floatOperand = Float.parseFloat(valueOperand);
                }
                catch (NumberFormatException nfe) {
                    log.error("Failed to parse operand " + valueOperand + " or observed value " + replyVar.getValue() + " as a Float, giving up");
                    log.info(nfe.getMessage());
                    throw new XmpUtilException("Operand '" + valueOperand + "' or observed value '" + replyVar.getValue() + "' is a malformed floating-point number");
                }
                if (LESS_THAN.equals(valueOperator)) {
                    return floatValue < floatOperand;
                }
                if (GREATER_THAN.equals(valueOperator)) {
                    return floatValue > floatOperand;
                }
                if (LESS_THAN_EQUALS.equals(valueOperator)) {
                    return floatValue <= floatOperand;
                }
                if (GREATER_THAN_EQUALS.equals(valueOperator)) {
                    return floatValue >= floatOperand;
                }
                if (EQUALS.equals(valueOperator)) {
                    return floatValue == floatOperand;
                }
                if (NOT_EQUAL.equals(valueOperator)) {
                    return floatValue != floatOperand;
                }
                log.error("Unknown value operator '" + valueOperator + "', giving up");
                throw new XmpUtilException("Value operator '" + valueOperator + "' unknown");
            }
            if (log.isDebugEnabled()) {
                log.debug("valueMeetsCriteria: operand " + valueOperand + " looks non-numeric, treating with String");
            }
            if (!EQUALS.equals(valueOperator)) {
                log.error("Value operator '" + valueOperator + "' does not apply for non-numeric value operand '" + valueOperand + "', giving up");
                throw new XmpUtilException("Value operator '" + valueOperator + "' does not apply for non-numeric value operand '" + valueOperand + "'");
            }
            if (caseSensitive) {
                return valueOperand.equals(replyVar.getValue());
            }
            return valueOperand.equalsIgnoreCase(replyVar.getValue());
        }
        if (log.isDebugEnabled()) {
            log.debug("handleScalarQuery: Response value |" + replyVar.getValue() + "| does not match for value operator |" + valueOperator + "| and value operand |" + valueOperand + "|, returning false");
            throw new XmpUtilException("Response value '" + replyVar.getValue() + "' does not match for value operator '" + valueOperator + "' and value operand '" + valueOperand + "'");
        }
        return false;
    }

    public static boolean handleScalarQuery(XmpSession session, String mib, String object, String valueOperator, String valueOperand, ThreadCategory log, boolean caseSensitive) throws XmpUtilException {
        XmpVar[] replyVars;
        XmpVar[] queryVars = new XmpVar[]{new XmpVar(mib, object, 13)};
        XmpMessage reply = session.queryVars(queryVars);
        if (reply == null) {
            log.warn("handleScalarQuery: query for object " + object + " from MIB " + mib + " failed, " + Xmp.errorStatusToString((int)session.getErrorStatus()));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("handleScalarQuery: query for object " + object + " from MIB " + mib + " succeeded.");
        }
        if ((replyVars = reply.getMIBVars())[0].getMibName().equals(mib) && replyVars[0].getObjName().equals(object)) {
            return XmpUtil.valueMeetsCriteria(replyVars[0], valueOperator, valueOperand, log, caseSensitive);
        }
        log.error("Observed MIB name (" + replyVars[0].getMibName() + ") or object name (" + replyVars[0].getObjName() + ") does not match specified MIB name (" + mib + ") or object name (" + object + "), giving up");
        throw new XmpUtilException("Received unexpected response (MIB: " + replyVars[0].getMibName() + " Object: " + replyVars[0].getObjName());
    }

    public static boolean handleTableQuery(XmpSession session, String mib, String table, String object, String instance, RE instanceRegex, String valueOperator, String valueOperand, int minMatches, int maxMatches, boolean maxMatchesUnbounded, ThreadCategory log, boolean caseSensitive) throws XmpUtilException {
        String[] tableInfo = new String[3];
        XmpVar[] queryVars = new XmpVar[1];
        int numMatches = 0;
        queryVars[0] = new XmpVar(mib, object, 13);
        tableInfo[0] = mib;
        tableInfo[1] = object;
        tableInfo[2] = instance;
        XmpMessage reply = session.queryTableVars(tableInfo, 0, queryVars);
        if (reply == null) {
            log.warn("handleTableQuery: query for object " + object + " from MIB " + mib + " failed, " + Xmp.errorStatusToString((int)session.getErrorStatus()));
            throw new XmpUtilException("XMP query failed (MIB " + mib + ", object " + object + "): " + Xmp.errorStatusToString((int)session.getErrorStatus()));
        }
        XmpVar[] replyVars = reply.getMIBVars();
        if (log.isDebugEnabled()) {
            log.debug("handleTableQuery: Got reply with " + replyVars.length + " variables");
        }
        for (XmpVar thisVar : replyVars) {
            String rowInstance = thisVar.getKey();
            if (instanceRegex != null && !instanceRegex.match(rowInstance)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("handleTableQuery: instance " + rowInstance + " does not match, skipping this row.");
                continue;
            }
            if (instanceRegex == null) {
                if (log.isDebugEnabled()) {
                    log.debug("handleTableQuery: instance match not specified, evaluating value of instance " + rowInstance);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("handleTableQuery: instance " + rowInstance + " matches, evaluating value");
            }
            if (!XmpUtil.valueMeetsCriteria(thisVar, valueOperator, valueOperand, log, caseSensitive)) continue;
            ++numMatches;
        }
        if (numMatches >= minMatches) {
            if (log.isDebugEnabled()) {
                log.debug("handleTableQuery: Found " + numMatches + " matches, meets specified minimum of " + minMatches);
            }
            if (maxMatchesUnbounded) {
                if (log.isDebugEnabled()) {
                    log.debug("handleTableQuery: Maximum matches unbounded, returning true");
                }
                return true;
            }
            if (numMatches <= maxMatches) {
                if (log.isDebugEnabled()) {
                    log.debug("handleTableQuery: Found " + numMatches + " matches, meets specified maximum of " + maxMatches + ", returning true");
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("handleTableQuery: Found " + numMatches + " matches, exceeds specified maximum of " + maxMatches + ", returning false");
            }
            throw new XmpUtilException("Found too many value matches (" + numMatches + " > " + maxMatches + ") for condition " + mib + "." + object + " " + valueOperator + " " + valueOperand);
        }
        if (log.isDebugEnabled()) {
            log.debug("Found only " + numMatches + " matches, too few to meet specified minimum of " + minMatches);
        }
        throw new XmpUtilException("Found too few value matches (" + numMatches + " < " + minMatches + ") for condition " + mib + "." + object + " " + valueOperator + " " + valueOperand);
    }
}

