/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionResource;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.config.collector.AttributeGroup;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;

class XmpCollectionResource
extends AbstractCollectionResource {
    String nodeTypeName;
    String instance;
    String resourceType;
    int nodeType;
    Set<AttributeGroup> listOfGroups;
    CollectionAgent agent;

    XmpCollectionResource(CollectionAgent agent, String resourceType, String nodeTypeName, String instance) {
        super(agent);
        this.agent = agent;
        this.nodeTypeName = nodeTypeName;
        this.resourceType = resourceType == null || resourceType.length() == 0 ? null : resourceType;
        this.nodeType = -1;
        if (instance != null) {
            this.instance = instance.replace('/', '_');
            this.instance = this.instance.replace('\\', '_');
            this.instance = this.instance.replace(':', '_');
            this.instance = this.instance.replace(' ', '_');
        } else {
            this.instance = instance;
        }
        this.listOfGroups = new HashSet<AttributeGroup>();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public File getResourceDir(RrdRepository repository) {
        File instDir;
        if (this.nodeTypeName.equalsIgnoreCase("node")) {
            return new File(repository.getRrdBaseDir(), this.getParent());
        }
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, this.getParent());
        if (this.resourceType != null) {
            File rtDir = new File(nodeDir, this.resourceType);
            instDir = new File(rtDir, this.instance);
        } else {
            instDir = new File(nodeDir, this.instance);
        }
        return instDir;
    }

    public void addAttributeGroup(AttributeGroup aGroup) {
        this.listOfGroups.add(aGroup);
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getResourceTypeName() {
        return this.nodeTypeName;
    }

    public void setResourceTypeName(String nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    public int getType() {
        return this.nodeType;
    }

    public void setType(int nodeType) {
        this.nodeType = nodeType;
    }

    public boolean rescanNeeded() {
        return false;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public Collection<AttributeGroup> getGroups() {
        return this.listOfGroups;
    }

    public String toString() {
        return "XmpCollectionResource for " + this.agent + " resType=" + this.resourceType + " instance=" + this.instance + " nodeType=" + this.nodeTypeName + " nodeType=" + this.nodeType;
    }

    public void visit(CollectionSetVisitor visitor) {
        this.log().debug("XmpCollectionResource: visit starting with " + this.getGroups().size() + " attribute groups");
        visitor.visitResource((CollectionResource)this);
        for (AttributeGroup ag : this.getGroups()) {
            ag.visit(visitor);
        }
        visitor.completeResource((CollectionResource)this);
        this.log().debug("XmpCollectionResource: visit finished for " + this.agent);
    }

    public String getParent() {
        return this.agent.getStorageDir().toString();
    }
}

