/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.PersistenceSelectorStrategy;
import org.opennms.netmgt.collection.api.StorageStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.springframework.orm.ObjectRetrievalFailureException;

public class XmlResourceType {
    private String m_resourceType;
    private PersistenceSelectorStrategy m_persistenceSelectorStrategy;
    private StorageStrategy m_storageStrategy;

    public XmlResourceType(CollectionAgent agent, ResourceType resourceType) {
        this.m_resourceType = resourceType.getName();
        this.instantiatePersistenceSelectorStrategy(resourceType.getPersistenceSelectorStrategy().getClazz());
        this.instantiateStorageStrategy(resourceType.getStorageStrategy().getClazz());
        this.m_storageStrategy.setParameters(resourceType.getStorageStrategy().getParameters());
        this.m_persistenceSelectorStrategy.setParameters(resourceType.getPersistenceSelectorStrategy().getParameters());
    }

    private void instantiatePersistenceSelectorStrategy(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            this.m_persistenceSelectorStrategy = (PersistenceSelectorStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(PersistenceSelectorStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
    }

    private void instantiateStorageStrategy(String className) {
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            this.m_storageStrategy = (StorageStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        this.m_storageStrategy.setResourceTypeName(this.m_resourceType);
    }

    public String getName() {
        return this.m_resourceType;
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public PersistenceSelectorStrategy getPersistenceSelectorStrategy() {
        return this.m_persistenceSelectorStrategy;
    }
}

