/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.protocols.http.FormFields;
import org.opennms.protocols.xml.config.Content;
import org.opennms.protocols.xml.config.Header;
import org.opennms.protocols.xml.config.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUrlConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUrlConnection.class);
    private URL m_url;
    private Request m_request;
    private DefaultHttpClient m_client;

    protected HttpUrlConnection(URL url, Request request) {
        super(url);
        this.m_url = url;
        this.m_request = request;
    }

    @Override
    public void connect() throws IOException {
        int timeout;
        if (this.m_client != null) {
            return;
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        if (this.m_request != null && (timeout = this.m_request.getParameterAsInt("timeout")) > 0) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
        }
        this.m_client = new DefaultHttpClient((HttpParams)httpParams);
        this.m_client.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
        this.m_client.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
        if (this.m_request != null) {
            String disableSslVerification;
            int retries = this.m_request.getParameterAsInt("retries");
            if (retries > 0) {
                this.m_client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(){

                    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                        if (executionCount <= this.getRetryCount() && (exception instanceof SocketTimeoutException || exception instanceof ConnectTimeoutException)) {
                            return true;
                        }
                        return super.retryRequest(exception, executionCount, context);
                    }
                });
            }
            if (Boolean.parseBoolean(disableSslVerification = this.m_request.getParameter("disable-ssl-verification"))) {
                SchemeRegistry registry = this.m_client.getConnectionManager().getSchemeRegistry();
                Scheme https = registry.getScheme("https");
                try {
                    SSLSocketFactory factory = new SSLSocketFactory(SSLContext.getInstance("EmptyKeyRelaxedTrust"), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    Scheme lenient = new Scheme(https.getName(), https.getDefaultPort(), (SchemeSocketFactory)factory);
                    registry.register(lenient);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.warn(e.getMessage());
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            String[] userInfo;
            if (this.m_client == null) {
                this.connect();
            }
            int port = this.m_url.getPort() > 0 ? this.m_url.getPort() : this.m_url.getDefaultPort();
            URIBuilder ub = new URIBuilder();
            ub.setPort(port);
            ub.setScheme(this.m_url.getProtocol());
            ub.setHost(this.m_url.getHost());
            ub.setPath(this.m_url.getPath());
            ub.setQuery(this.m_url.getQuery());
            HttpGet request = null;
            if (this.m_request != null && this.m_request.getMethod().equalsIgnoreCase("post")) {
                Content cnt = this.m_request.getContent();
                HttpPost post = new HttpPost(ub.build());
                ContentType contentType = ContentType.create((String)cnt.getType());
                LOG.info("Processing POST request for %s", (Object)contentType);
                if (contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                    FormFields fields = (FormFields)((Object)JaxbUtils.unmarshal(FormFields.class, (String)cnt.getData()));
                    post.setEntity((HttpEntity)fields.getEntity());
                } else {
                    StringEntity entity = new StringEntity(cnt.getData(), contentType);
                    post.setEntity((HttpEntity)entity);
                }
                request = post;
            } else {
                request = new HttpGet(ub.build());
            }
            if (this.m_request != null) {
                for (Header header : this.m_request.getHeaders()) {
                    request.addHeader(header.getName(), header.getValue());
                }
            }
            String[] stringArray = userInfo = this.m_url.getUserInfo() == null ? null : this.m_url.getUserInfo().split(":");
            if (userInfo != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userInfo[0], userInfo[1]);
                request.addHeader(BasicScheme.authenticate((Credentials)credentials, (String)"UTF-8", (boolean)false));
            }
            CloseableHttpResponse response = this.m_client.execute((HttpUriRequest)request);
            return response.getEntity().getContent();
        }
        catch (Exception e) {
            throw new IOException("Can't retrieve " + this.m_url.getPath() + " from " + this.m_url.getHost() + " because " + e.getMessage(), e);
        }
    }

    public void disconnect() {
        if (this.m_client != null) {
            this.m_client.getConnectionManager().shutdown();
        }
    }
}

