/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;

public class XmlDataCollectionConfigFactory {
    public static final String XML_DATACOLLECTION_CONFIG_FILE = "xml-datacollection-config.xml";
    private XmlDataCollectionConfig m_xmlDataCollectionConfig = null;

    public XmlDataCollectionConfigFactory() {
        try {
            File cfgFile = ConfigFileConstants.getConfigFileByName((String)XML_DATACOLLECTION_CONFIG_FILE);
            XmlDataCollectionConfigFactory.log().debug("init: config file path: " + cfgFile.getPath());
            FileInputStream reader = new FileInputStream(cfgFile);
            this.unmarshall(reader);
            ((InputStream)reader).close();
        }
        catch (IOException e) {
            XmlDataCollectionConfigFactory.log().error(e.getMessage(), (Throwable)e);
        }
    }

    public XmlDataCollectionConfig unmarshall(InputStream configFile) {
        try {
            XmlDataCollectionConfig jdcc;
            InputStream jdccStream = configFile;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XmlDataCollectionConfig.class});
            Unmarshaller um = context.createUnmarshaller();
            um.setSchema(null);
            this.m_xmlDataCollectionConfig = jdcc = (XmlDataCollectionConfig)um.unmarshal(jdccStream);
            return jdcc;
        }
        catch (Throwable e) {
            XmlDataCollectionConfigFactory.log().error(e.getMessage(), e);
            return this.m_xmlDataCollectionConfig;
        }
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance(XmlDataCollectionConfig.class);
    }
}

