/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.protocols.xml.collector.XmlCollectionResource;

public class XmlMultiInstanceCollectionResource
extends XmlCollectionResource {
    private String m_instance;
    private String m_resourceTypeName;

    public XmlMultiInstanceCollectionResource(CollectionAgent agent, String instance, String name) {
        super(agent);
        this.m_instance = instance;
        this.m_resourceTypeName = name;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, String.valueOf(this.m_agent.getNodeId()));
        File typeDir = new File(nodeDir, this.m_resourceTypeName);
        File instDir = new File(typeDir, this.getInstance());
        if (this.log().isDebugEnabled()) {
            this.log().debug("getResourceDir: " + instDir.toString());
        }
        return instDir;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_resourceTypeName;
    }

    @Override
    public String getInstance() {
        return this.m_instance.replaceAll("\\s+", "_").replaceAll(":", "_").replaceAll("\\\\", "_").replaceAll("[\\[\\]]", "_").replaceAll("[|/]", "_").replaceAll("=", "").replaceAll("[_]+$", "").replaceAll("___", "_");
    }

    public String toString() {
        return "node[" + this.m_agent.getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getInstance() + "]";
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

